/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;

public class JRProperties {
    protected static final String DEFAULT_PROPERTIES_FILE = "jasperreports.properties";
    public static final String PROPERTY_PREFIX = "net.sf.jasperreports.";
    public static final String PROPERTIES_FILE = "net.sf.jasperreports.properties";
    public static final String COMPILER_CLASS = "net.sf.jasperreports.compiler.class";
    public static final String COMPILER_XML_VALIDATION = "net.sf.jasperreports.compiler.xml.validation";
    public static final String COMPILER_KEEP_JAVA_FILE = "net.sf.jasperreports.compiler.keep.java.file";
    public static final String COMPILER_TEMP_DIR = "net.sf.jasperreports.compiler.temp.dir";
    public static final String COMPILER_CLASSPATH = "net.sf.jasperreports.compiler.classpath";
    public static final String EXPORT_XML_VALIDATION = "net.sf.jasperreports.export.xml.validation";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String QUERY_EXECUTER_FACTORY_PREFIX = "net.sf.jasperreports.query.executer.factory.";
    public static final String SUBREPORT_RUNNER_FACTORY = "net.sf.jasperreports.subreport.runner.factory";
    public static final String PDF_FORCE_LINEBREAK_POLICY = "net.sf.jasperreports.export.pdf.force.linebreak.policy";
    protected static Properties props;
    protected static Properties savedProps;

    protected static void initProperties() {
        try {
            Properties properties = JRProperties.getDefaults();
            String string = JRProperties.getSystemProperty(PROPERTIES_FILE);
            if (string == null) {
                props = JRProperties.loadProperties(DEFAULT_PROPERTIES_FILE, properties);
                if (props == null) {
                    props = new Properties(properties);
                }
            } else {
                props = JRProperties.loadProperties(string, properties);
                if (props == null) {
                    throw new JRRuntimeException("Could not load properties file \"" + string + "\"");
                }
            }
            JRProperties.loadSystemProperties();
        }
        catch (JRException jRException) {
            throw new JRRuntimeException("Error loading the properties", jRException);
        }
    }

    protected static void loadSystemProperties() {
        JRProperties.loadSystemProperty("jasper.reports.compiler.class", COMPILER_CLASS);
        JRProperties.loadSystemProperty("jasper.reports.compile.xml.validation", COMPILER_XML_VALIDATION);
        JRProperties.loadSystemProperty("jasper.reports.export.xml.validation", EXPORT_XML_VALIDATION);
        JRProperties.loadSystemProperty("jasper.reports.compile.keep.java.file", COMPILER_KEEP_JAVA_FILE);
        JRProperties.loadSystemProperty("jasper.reports.compile.temp", COMPILER_TEMP_DIR);
        JRProperties.loadSystemProperty("jasper.reports.compile.class.path", COMPILER_CLASSPATH);
    }

    protected static Properties getDefaults() throws JRException {
        String string;
        Properties properties = new Properties();
        InputStream inputStream = JRProperties.class.getResourceAsStream("/default.jasperreports.properties");
        if (inputStream == null) {
            throw new JRException("Default properties file not found.");
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new JRException("Failed to load default properties.", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        String string2 = JRProperties.getSystemProperty("user.dir");
        if (string2 != null) {
            properties.setProperty(COMPILER_TEMP_DIR, string2);
        }
        if ((string = JRProperties.getSystemProperty("java.class.path")) != null) {
            properties.setProperty(COMPILER_CLASSPATH, string);
        }
        return properties;
    }

    protected static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    protected static void loadSystemProperty(String string, String string2) {
        String string3 = JRProperties.getSystemProperty(string);
        if (string3 != null) {
            props.setProperty(string2, string3);
        }
    }

    public static Properties loadProperties(String string, Properties properties) throws JRException {
        Properties properties2 = null;
        InputStream inputStream = null;
        try {
            inputStream = JRLoader.getLocationInputStream(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (inputStream != null) {
            properties2 = new Properties(properties);
            try {
                properties2.load(inputStream);
            }
            catch (IOException iOException) {
                throw new JRException("Failed to load properties file \"" + string + "\"", iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties2;
    }

    public static String getProperty(String string) {
        return props.getProperty(string);
    }

    public static boolean getBooleanProperty(String string) {
        return JRProperties.asBoolean(props.getProperty(string));
    }

    public static int getIntegerProperty(String string) {
        return JRProperties.asInteger(props.getProperty(string));
    }

    public static boolean asBoolean(String string) {
        return Boolean.valueOf(string);
    }

    public static int asInteger(String string) {
        return Integer.parseInt(string);
    }

    public static void setProperty(String string, String string2) {
        props.setProperty(string, string2);
    }

    public static void setProperty(String string, boolean bl) {
        props.setProperty(string, String.valueOf(bl));
    }

    public static void backupProperties() {
        savedProps = (Properties)props.clone();
    }

    public static void restoreProperties() {
        if (savedProps != null) {
            try {
                props.clear();
                props.putAll((Map<?, ?>)savedProps);
            }
            finally {
                savedProps = null;
            }
        }
    }

    public static List getProperties(String string) {
        int n = string.length();
        ArrayList<PropertySuffix> arrayList = new ArrayList<PropertySuffix>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(n);
            String string4 = props.getProperty(string2);
            arrayList.add(new PropertySuffix(string2, string3, string4));
        }
        return arrayList;
    }

    public static String getProperty(JRPropertiesMap jRPropertiesMap, String string) {
        String string2 = null;
        if (jRPropertiesMap != null) {
            string2 = jRPropertiesMap.getProperty(string);
        }
        if (string2 == null) {
            string2 = props.getProperty(string);
        }
        return string2;
    }

    public static boolean getBooleanProperty(JRPropertiesMap jRPropertiesMap, String string, boolean bl) {
        String string2 = JRProperties.getProperty(jRPropertiesMap, string);
        return string2 == null ? bl : JRProperties.asBoolean(string2);
    }

    public static int getIntegerProperty(JRPropertiesMap jRPropertiesMap, String string, int n) {
        String string2 = JRProperties.getProperty(jRPropertiesMap, string);
        return string2 == null ? n : JRProperties.asInteger(string2);
    }

    public static long asLong(String string) {
        return Long.parseLong(string);
    }

    public static long getLongProperty(String string) {
        return JRProperties.asLong(props.getProperty(string));
    }

    public static long getLongProperty(JRPropertiesMap jRPropertiesMap, String string, int n) {
        String string2 = JRProperties.getProperty(jRPropertiesMap, string);
        return string2 == null ? (long)n : JRProperties.asLong(string2);
    }

    static {
        JRProperties.initProperties();
    }

    public static class PropertySuffix {
        protected final String key;
        protected final String suffix;
        protected final String value;

        public PropertySuffix(String string, String string2, String string3) {
            this.key = string;
            this.suffix = string2;
            this.value = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getValue() {
            return this.value;
        }
    }
}

