/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final Log log = LogFactory.getLog(JRFillTextElement.class);
    private boolean isLeftToRight = true;
    private TextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributesMap = new HashMap();
    protected TextChopper textChopper = null;
    protected final JRReportFont reportFont;
    private static TextChopper simpleTextChopper = new TextChopper(){

        @Override
        public String chop(JRFillTextElement jRFillTextElement, int n, int n2) {
            return jRFillTextElement.getStyledText().getText().substring(n, n2);
        }
    };
    private static TextChopper styledTextChopper = new TextChopper(){

        @Override
        public String chop(JRFillTextElement jRFillTextElement, int n, int n2) {
            return jRFillTextElement.filler.getStyledTextParser().write(jRFillTextElement.getStyledTextAttributes(), new AttributedString(jRFillTextElement.getStyledText().getAttributedString().getIterator(), n, n2).getIterator(), jRFillTextElement.getText().substring(n, n2));
        }
    };

    protected JRFillTextElement(JRBaseFiller jRBaseFiller, JRTextElement jRTextElement, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRTextElement, jRFillObjectFactory);
        this.reportFont = jRFillObjectFactory.getReportFont(jRTextElement.getReportFont());
        this.createTextMeasurer();
        this.createTextChopper();
    }

    protected JRFillTextElement(JRFillTextElement jRFillTextElement, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillTextElement, jRFillCloneFactory);
        this.reportFont = jRFillTextElement.reportFont;
        this.createTextMeasurer();
        this.createTextChopper();
    }

    private void createTextMeasurer() {
        this.textMeasurer = new TextMeasurer(this);
    }

    private void createTextChopper() {
        this.textChopper = this.isStyledText() ? styledTextChopper : simpleTextChopper;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getTextAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public void setTextAlignment(byte by) {
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte by) {
    }

    @Override
    public void setHorizontalAlignment(Byte by) {
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(byte by) {
    }

    @Override
    public void setVerticalAlignment(Byte by) {
    }

    @Override
    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    @Override
    public Byte getOwnRotation() {
        return ((JRTextElement)this.parent).getOwnRotation();
    }

    @Override
    public void setRotation(byte by) {
    }

    @Override
    public void setRotation(Byte by) {
    }

    @Override
    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    @Override
    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(byte by) {
    }

    @Override
    public void setLineSpacing(Byte by) {
    }

    @Override
    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    @Override
    public Boolean isOwnStyledText() {
        return ((JRTextElement)this.parent).isOwnStyledText();
    }

    @Override
    public void setStyledText(boolean bl) {
    }

    @Override
    public void setStyledText(Boolean bl) {
    }

    @Override
    public JRBox getBox() {
        return this;
    }

    @Override
    public JRFont getFont() {
        return this;
    }

    protected Map getStyledTextAttributes() {
        JRStyle jRStyle = this.getStyle();
        HashMap<TextAttribute, Color> hashMap = (HashMap<TextAttribute, Color>)this.styledTextAttributesMap.get(jRStyle);
        if (hashMap == null) {
            hashMap = new HashMap<TextAttribute, Color>();
            JRFontUtil.setAttributes(hashMap, this);
            hashMap.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                hashMap.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(jRStyle, hashMap);
        }
        return hashMap;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float f) {
        this.lineSpacingFactor = f;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float f) {
        this.leadingOffset = f;
    }

    protected byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float f) {
        this.textHeight = f;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int n) {
        this.textStart = n;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int n) {
        this.textEnd = n;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String string) {
        this.rawText = string;
        this.styledText = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    @Override
    protected void rewind() {
        this.textStart = 0;
        this.textEnd = 0;
    }

    protected JRStyledText getStyledText() {
        String string;
        if (this.styledText == null && (string = this.getRawText()) != null) {
            block5: {
                if (this.isStyledText()) {
                    try {
                        this.styledText = this.filler.getStyledTextParser().parse(this.getStyledTextAttributes(), string);
                    }
                    catch (SAXException sAXException) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn("Invalid styled text.", sAXException);
                    }
                }
            }
            if (this.styledText == null) {
                this.styledText = new JRStyledText();
                this.styledText.append(string);
                this.styledText.addRun(new JRStyledText.Run(this.getStyledTextAttributes(), 0, string.length()));
            }
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText jRStyledText = this.getStyledText();
        if (jRStyledText == null) {
            return null;
        }
        return jRStyledText.getText();
    }

    protected void chopTextElement(int n) {
        JRStyledText jRStyledText = this.getStyledText();
        if (jRStyledText == null) {
            return;
        }
        String string = this.getText().substring(this.getTextEnd());
        if (string.length() == 0) {
            return;
        }
        this.textMeasurer.measure(jRStyledText, string, this.getTextEnd(), n);
        this.isLeftToRight = this.textMeasurer.isLeftToRight();
        this.setTextHeight(this.textMeasurer.getTextHeight());
        if (this.getRotation() == 0) {
            this.setStretchHeight((int)this.getTextHeight() + this.getTopPadding() + this.getBottomPadding());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.textMeasurer.getTextOffset());
        this.setLineSpacingFactor(this.textMeasurer.getLineSpacingFactor());
        this.setLeadingOffset(this.textMeasurer.getLeadingOffset());
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    @Override
    public void setBorder(byte by) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color color) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    @Override
    public void setPadding(int n) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte by) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color color) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int n) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte by) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color color) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int n) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte by) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color color) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int n) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte by) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color color) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int n) {
    }

    @Override
    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    @Override
    public void setReportFont(JRReportFont jRReportFont) {
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    @Override
    public void setFontName(String string) {
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    @Override
    public void setBold(boolean bl) {
    }

    @Override
    public void setBold(Boolean bl) {
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    @Override
    public void setItalic(boolean bl) {
    }

    @Override
    public void setItalic(Boolean bl) {
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    @Override
    public void setUnderline(boolean bl) {
    }

    @Override
    public void setUnderline(Boolean bl) {
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    @Override
    public void setStrikeThrough(boolean bl) {
    }

    @Override
    public void setStrikeThrough(Boolean bl) {
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    @Override
    public void setFontSize(int n) {
    }

    @Override
    public void setFontSize(Integer n) {
    }

    @Override
    public int getSize() {
        return this.getFontSize();
    }

    @Override
    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    @Override
    public void setSize(int n) {
    }

    @Override
    public void setSize(Integer n) {
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    @Override
    public void setPdfFontName(String string) {
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    @Override
    public void setPdfEncoding(String string) {
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    @Override
    public void setPdfEmbedded(boolean bl) {
        this.setPdfEmbedded(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean bl) {
    }

    @Override
    public void setBorder(Byte by) {
    }

    @Override
    public void setPadding(Integer n) {
    }

    @Override
    public void setTopBorder(Byte by) {
    }

    @Override
    public void setTopPadding(Integer n) {
    }

    @Override
    public void setLeftBorder(Byte by) {
    }

    @Override
    public void setLeftPadding(Integer n) {
    }

    @Override
    public void setBottomBorder(Byte by) {
    }

    @Override
    public void setBottomPadding(Integer n) {
    }

    @Override
    public void setRightBorder(Byte by) {
    }

    @Override
    public void setRightPadding(Integer n) {
    }

    @Override
    public void setHeight(int n) {
        super.setHeight(n);
        this.createTextMeasurer();
    }

    @Override
    public void setWidth(int n) {
        super.setWidth(n);
        this.createTextMeasurer();
    }

    protected static interface TextChopper {
        public String chop(JRFillTextElement var1, int var2, int var3);
    }
}

