/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    private JRFillFrameElements frameContainer;
    private Map bottomTemplateFrames;
    private Map topTemplateFrames;
    private Map topBottomTemplateFrames;
    private boolean first;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller jRBaseFiller, JRFrame jRFrame, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRFrame, jRFillObjectFactory);
        this.parentFrame = jRFrame;
        this.frameContainer = new JRFillFrameElements(jRFillObjectFactory);
        this.bottomTemplateFrames = new HashMap();
        this.topTemplateFrames = new HashMap();
        this.topBottomTemplateFrames = new HashMap();
        this.setShrinkable(true);
    }

    protected JRFillFrame(JRFillFrame jRFillFrame, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillFrame, jRFillCloneFactory);
        this.parentFrame = jRFillFrame.parentFrame;
        this.frameContainer = new JRFillFrameElements(jRFillFrame.frameContainer, jRFillCloneFactory);
        this.bottomTemplateFrames = jRFillFrame.bottomTemplateFrames;
        this.topTemplateFrames = jRFillFrame.topTemplateFrames;
        this.topBottomTemplateFrames = jRFillFrame.topBottomTemplateFrames;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    protected void evaluate(byte by) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.frameContainer.evaluate(by);
            boolean bl = true;
            JRFillElement[] jRFillElementArray = (JRFillElement[])this.getElements();
            for (int i = 0; bl && i < jRFillElementArray.length; bl &= jRFillElementArray[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(bl);
        }
        this.filling = false;
    }

    @Override
    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    @Override
    protected boolean prepare(int n, boolean bl) throws JRException {
        super.prepare(n, bl);
        if (!this.isToPrint()) {
            return false;
        }
        this.first = !bl || !this.filling;
        int n2 = this.first ? this.getTopPadding() : 0;
        int n3 = this.getBottomPadding();
        if (n < this.getRelativeY() - this.getY() - this.getBandBottomY() - n2) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || bl && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && bl && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        int n4 = n - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        int n5 = n4 + n3 + this.getTopPadding() - n2;
        this.frameContainer.prepareElements(n5, true);
        boolean bl2 = this.frameContainer.willOverflow();
        if (bl2) {
            this.fillBottomBorder = false;
            this.setStretchHeight(this.getHeight() + n4);
        } else {
            int n6 = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + n2 + n3;
            if (n6 <= this.getHeight() + n4) {
                this.fillBottomBorder = true;
                this.setStretchHeight(n6);
            } else {
                this.fillBottomBorder = false;
                this.setStretchHeight(this.getHeight() + n4);
            }
        }
        this.filling = bl2;
        return bl2;
    }

    @Override
    protected void setStretchHeight(int n) {
        super.setStretchHeight(n);
        int n2 = this.first ? this.getTopPadding() : 0;
        int n3 = this.fillBottomBorder ? this.getBottomPadding() : 0;
        this.frameContainer.setStretchHeight(n + this.frameContainer.getFirstY() - n2 - n3);
    }

    @Override
    protected void stretchHeightFinal() {
        this.frameContainer.stretchElements();
        this.frameContainer.moveBandBottomElements();
        this.frameContainer.removeBlankElements();
        int n = this.first ? this.getTopPadding() : 0;
        int n2 = this.fillBottomBorder ? this.getBottomPadding() : 0;
        super.setStretchHeight(this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + n + n2);
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintFrame jRTemplatePrintFrame = new JRTemplatePrintFrame(this.getTemplate());
        jRTemplatePrintFrame.setX(this.getX());
        jRTemplatePrintFrame.setY(this.getRelativeY());
        jRTemplatePrintFrame.setWidth(this.getWidth());
        this.frameContainer.fillElements(jRTemplatePrintFrame);
        jRTemplatePrintFrame.setHeight(this.getStretchHeight());
        return jRTemplatePrintFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRStyle jRStyle = this.getStyle();
        Map map = this.first ? (this.fillBottomBorder ? this.templates : this.bottomTemplateFrames) : (this.fillBottomBorder ? this.topTemplateFrames : this.topBottomTemplateFrames);
        JRTemplateFrame jRTemplateFrame = (JRTemplateFrame)map.get(jRStyle);
        if (jRTemplateFrame == null) {
            jRTemplateFrame = new JRTemplateFrame(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            if (this.first) {
                if (!this.fillBottomBorder) {
                    JRBaseBox jRBaseBox = new JRBaseBox(this, false, false, false, true);
                    jRTemplateFrame.setBox(jRBaseBox);
                }
            } else if (this.fillBottomBorder) {
                JRBaseBox jRBaseBox = new JRBaseBox(this, false, false, true, false);
                jRTemplateFrame.setBox(jRBaseBox);
            } else {
                JRBaseBox jRBaseBox = new JRBaseBox(this, false, false, true, true);
                jRTemplateFrame.setBox(jRBaseBox);
            }
            map.put(jRStyle, jRTemplateFrame);
        }
        return jRTemplateFrame;
    }

    @Override
    protected void resolveElement(JRPrintElement jRPrintElement, byte by) {
    }

    @Override
    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    @Override
    public List getChildren() {
        return this.frameContainer.getChildren();
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getFrame(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeFrame(this);
    }

    @Override
    public JRElement getElementByKey(String string) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), string);
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return new JRFillFrame(this, jRFillCloneFactory);
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return this.parentFrame.getOwnBorder();
    }

    @Override
    public void setBorder(byte by) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return this.parentFrame.getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color color) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return this.parentFrame.getOwnPadding();
    }

    @Override
    public void setPadding(int n) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return this.parentFrame.getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte by) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.parentFrame.getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color color) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.parentFrame.getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int n) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return this.parentFrame.getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte by) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.parentFrame.getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color color) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.parentFrame.getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int n) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return this.parentFrame.getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte by) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.parentFrame.getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color color) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.parentFrame.getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int n) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return this.parentFrame.getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte by) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.parentFrame.getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color color) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.parentFrame.getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int n) {
    }

    @Override
    public void setBorder(Byte by) {
    }

    @Override
    public void setPadding(Integer n) {
    }

    @Override
    public void setTopBorder(Byte by) {
    }

    @Override
    public void setTopPadding(Integer n) {
    }

    @Override
    public void setLeftBorder(Byte by) {
    }

    @Override
    public void setLeftPadding(Integer n) {
    }

    @Override
    public void setBottomBorder(Byte by) {
    }

    @Override
    public void setBottomPadding(Integer n) {
    }

    @Override
    public void setRightBorder(Byte by) {
    }

    @Override
    public void setRightPadding(Integer n) {
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory jRFillObjectFactory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, jRFillObjectFactory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements jRFillFrameElements, JRFillCloneFactory jRFillCloneFactory) {
            super(jRFillFrameElements, jRFillCloneFactory);
            this.initElements();
        }

        @Override
        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getTopPadding() - JRFillFrame.this.getBottomPadding();
        }
    }
}

