/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;

class JRDoubleCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRDoubleCountIncrementer mainInstance = new JRDoubleCountIncrementer();

    private JRDoubleCountIncrementer() {
    }

    public static JRDoubleCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable jRCalculable, Object object, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRDoubleIncrementerFactory.ZERO;
        }
        if (object == null) {
            return number;
        }
        return new Double(number.doubleValue() + 1.0);
    }

    @Override
    public Object combine(JRCalculable jRCalculable, JRCalculable jRCalculable2, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        Number number2 = (Number)jRCalculable2.getValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRDoubleIncrementerFactory.ZERO;
        }
        if (number2 == null) {
            return number;
        }
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    @Override
    public Object initialValue() {
        return JRDoubleIncrementerFactory.ZERO;
    }
}

