/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;

public class JRSortableDataSource
implements JRRewindableDataSource {
    private List records = new ArrayList();
    private Iterator iterator = null;
    private Object[] currentRecord = null;
    private Map fieldIndexMap = new HashMap();
    protected Collator collator = null;

    public JRSortableDataSource(JRDataSource jRDataSource, JRField[] jRFieldArray, JRSortField[] jRSortFieldArray, Locale locale) throws JRException {
        if (jRFieldArray == null) {
            jRFieldArray = new JRField[]{};
        }
        if (jRSortFieldArray == null) {
            jRSortFieldArray = new JRSortField[]{};
        }
        JRSortableDataSource.verifySortFields(jRFieldArray, jRSortFieldArray);
        this.collator = Collator.getInstance(locale);
        for (int i = 0; i < jRFieldArray.length; ++i) {
            this.fieldIndexMap.put(jRFieldArray[i].getName(), new Integer(i));
        }
        int[] nArray = new int[jRSortFieldArray.length];
        int[] nArray2 = new int[jRSortFieldArray.length];
        boolean[] blArray = new boolean[jRSortFieldArray.length];
        block1: for (int i = 0; i < jRSortFieldArray.length; ++i) {
            JRSortField jRSortField = jRSortFieldArray[i];
            nArray[i] = (Integer)this.fieldIndexMap.get(jRSortField.getName());
            nArray2[i] = 0 == jRSortField.getOrder() ? 1 : -1;
            blArray[i] = false;
            for (int j = 0; j < jRFieldArray.length; ++j) {
                JRField jRField = jRFieldArray[j];
                if (!jRSortField.getName().equals(jRField.getName())) continue;
                blArray[i] = String.class.getName().equals(jRField.getValueClassName());
                continue block1;
            }
        }
        if (jRDataSource != null) {
            while (jRDataSource.next()) {
                Object[] objectArray = new Object[jRFieldArray.length];
                for (int i = 0; i < jRFieldArray.length; ++i) {
                    objectArray[i] = jRDataSource.getFieldValue(jRFieldArray[i]);
                }
                this.records.add(objectArray);
            }
        }
        Collections.sort(this.records, new DataSourceComparator(nArray, nArray2, blArray));
        this.iterator = this.records.iterator();
    }

    @Override
    public boolean next() {
        boolean bl = false;
        if (this.iterator != null && (bl = this.iterator.hasNext())) {
            this.currentRecord = (Object[])this.iterator.next();
        }
        return bl;
    }

    @Override
    public Object getFieldValue(JRField jRField) {
        Integer n = (Integer)this.fieldIndexMap.get(jRField.getName());
        if (n == null) {
            throw new JRRuntimeException("Field \"" + jRField.getName() + "\" not found in sortable data source.");
        }
        return this.currentRecord[n];
    }

    @Override
    public void moveFirst() {
        this.iterator = this.records.iterator();
    }

    public static void verifySortFields(JRField[] jRFieldArray, JRSortField[] jRSortFieldArray) {
        if (jRFieldArray != null && jRSortFieldArray != null) {
            for (int i = 0; i < jRSortFieldArray.length; ++i) {
                String string = jRSortFieldArray[i].getName();
                boolean bl = false;
                for (int j = 0; !bl && j < jRFieldArray.length; ++j) {
                    bl = string.equals(jRFieldArray[j].getName());
                }
                if (bl) continue;
                throw new JRRuntimeException("Sort field \"" + string + "\" not found in the list of data source fields.");
            }
        }
    }

    class DataSourceComparator
    implements Comparator {
        int[] sortIndexes = null;
        int[] sortOrders = null;
        boolean[] collatorFlags = null;

        public DataSourceComparator(int[] nArray, int[] nArray2, boolean[] blArray) {
            this.sortIndexes = nArray;
            this.sortOrders = nArray2;
            this.collatorFlags = blArray;
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n = 0;
            for (int i = 0; i < this.sortIndexes.length; ++i) {
                int n2 = this.sortIndexes[i];
                Comparable comparable = (Comparable)objectArray[n2];
                Comparable comparable2 = (Comparable)objectArray2[n2];
                n = comparable == null ? (comparable2 == null ? 0 : -1) : (comparable2 == null ? 1 : (this.collatorFlags[i] ? JRSortableDataSource.this.collator.compare(comparable, comparable2) : comparable.compareTo(comparable2)));
                if ((n *= this.sortOrders[i]) == 0) continue;
                return n;
            }
            return n;
        }
    }
}

