/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseCrosstab
extends JRBaseElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    protected int id;
    protected JRCrosstabParameter[] parameters;
    protected JRVariable[] variables;
    protected JRExpression parametersMapExpression;
    protected JRCrosstabDataset dataset;
    protected JRCrosstabRowGroup[] rowGroups;
    protected JRCrosstabColumnGroup[] columnGroups;
    protected JRCrosstabMeasure[] measures;
    protected int columnBreakOffset;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected JRCrosstabCell[][] cells;
    protected JRCellContents whenNoDataCell;
    protected JRCellContents headerCell;

    public JRBaseCrosstab(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory, int n) {
        super(jRCrosstab, jRBaseObjectFactory);
        this.id = n;
        this.columnBreakOffset = jRCrosstab.getColumnBreakOffset();
        this.repeatColumnHeaders = jRCrosstab.isRepeatColumnHeaders();
        this.repeatRowHeaders = jRCrosstab.isRepeatRowHeaders();
        this.dataset = jRBaseObjectFactory.getCrosstabDataset(jRCrosstab.getDataset());
        this.copyParameters(jRCrosstab, jRBaseObjectFactory);
        this.copyVariables(jRCrosstab, jRBaseObjectFactory);
        this.headerCell = jRBaseObjectFactory.getCell(jRCrosstab.getHeaderCell());
        this.copyRowGroups(jRCrosstab, jRBaseObjectFactory);
        this.copyColumnGroups(jRCrosstab, jRBaseObjectFactory);
        this.copyMeasures(jRCrosstab, jRBaseObjectFactory);
        this.copyCells(jRCrosstab, jRBaseObjectFactory);
        this.whenNoDataCell = jRBaseObjectFactory.getCell(jRCrosstab.getWhenNoDataCell());
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    private void copyParameters(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            this.parameters = new JRCrosstabParameter[jRCrosstabParameterArray.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = jRBaseObjectFactory.getCrosstabParameter(jRCrosstabParameterArray[i]);
            }
        }
        this.parametersMapExpression = jRBaseObjectFactory.getExpression(jRCrosstab.getParametersMapExpression());
    }

    private void copyVariables(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRVariable[] jRVariableArray = jRCrosstab.getVariables();
        if (jRVariableArray != null) {
            this.variables = new JRVariable[jRVariableArray.length];
            for (int i = 0; i < jRVariableArray.length; ++i) {
                this.variables[i] = jRBaseObjectFactory.getVariable(jRVariableArray[i]);
            }
        }
    }

    private void copyRowGroups(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray != null) {
            this.rowGroups = new JRCrosstabRowGroup[jRCrosstabRowGroupArray.length];
            for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
                this.rowGroups[i] = jRBaseObjectFactory.getCrosstabRowGroup(jRCrosstabRowGroupArray[i]);
            }
        }
    }

    private void copyColumnGroups(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        if (jRCrosstabColumnGroupArray != null) {
            this.columnGroups = new JRCrosstabColumnGroup[jRCrosstabColumnGroupArray.length];
            for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
                this.columnGroups[i] = jRBaseObjectFactory.getCrosstabColumnGroup(jRCrosstabColumnGroupArray[i]);
            }
        }
    }

    private void copyMeasures(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        if (jRCrosstabMeasureArray != null) {
            this.measures = new JRCrosstabMeasure[jRCrosstabMeasureArray.length];
            for (int i = 0; i < jRCrosstabMeasureArray.length; ++i) {
                this.measures[i] = jRBaseObjectFactory.getCrosstabMeasure(jRCrosstabMeasureArray[i]);
            }
        }
    }

    private void copyCells(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        if (jRCrosstabCellArray != null) {
            this.cells = new JRCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
            for (int i = 0; i <= this.rowGroups.length; ++i) {
                for (int j = 0; j <= this.columnGroups.length; ++j) {
                    this.cells[i][j] = jRBaseObjectFactory.getCrosstabCell(jRCrosstabCellArray[i][j]);
                }
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getCrosstab(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeCrosstab(this);
    }

    @Override
    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.cells;
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public static JRElement getElementByKey(JRCrosstab jRCrosstab, String string) {
        JRElement jRElement = null;
        if (jRCrosstab.getHeaderCell() != null) {
            jRElement = jRCrosstab.getHeaderCell().getElementByKey(string);
        }
        if ((jRElement = JRBaseCrosstab.getHeadersElement(jRCrosstab.getRowGroups(), string)) == null) {
            jRElement = JRBaseCrosstab.getHeadersElement(jRCrosstab.getColumnGroups(), string);
        }
        if (jRElement == null) {
            if (jRCrosstab instanceof JRDesignCrosstab) {
                List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
                Iterator iterator = list.iterator();
                while (jRElement == null && iterator.hasNext()) {
                    JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)iterator.next();
                    jRElement = jRCrosstabCell.getContents().getElementByKey(string);
                }
            } else {
                JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
                for (int i = jRCrosstabCellArray.length - 1; jRElement == null && i >= 0; --i) {
                    for (int j = jRCrosstabCellArray[i].length - 1; jRElement == null && j >= 0; --j) {
                        JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[i][j];
                        if (jRCrosstabCell == null) continue;
                        jRElement = jRCrosstabCell.getContents().getElementByKey(string);
                    }
                }
            }
        }
        if (jRElement == null && jRCrosstab.getWhenNoDataCell() != null) {
            jRElement = jRCrosstab.getWhenNoDataCell().getElementByKey(string);
        }
        return jRElement;
    }

    private static JRElement getHeadersElement(JRCrosstabGroup[] jRCrosstabGroupArray, String string) {
        JRElement jRElement = null;
        if (jRCrosstabGroupArray != null) {
            for (int i = 0; jRElement == null && i < jRCrosstabGroupArray.length; ++i) {
                JRCellContents jRCellContents = jRCrosstabGroupArray[i].getHeader();
                jRElement = jRCellContents.getElementByKey(string);
                if (jRElement != null) continue;
                JRCellContents jRCellContents2 = jRCrosstabGroupArray[i].getTotalHeader();
                jRElement = jRCellContents2.getElementByKey(string);
            }
        }
        return jRElement;
    }

    @Override
    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }
}

