/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.pumps;

import foxtrot.EventPump;
import foxtrot.Task;
import foxtrot.pumps.EventFilter;
import foxtrot.pumps.EventFilterable;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JDK13QueueEventPump
implements EventPump,
EventFilterable {
    private static final boolean debug = false;
    private EventFilter filter;

    @Override
    public void setEventFilter(EventFilter eventFilter) {
        this.filter = eventFilter;
    }

    @Override
    public EventFilter getEventFilter() {
        return this.filter;
    }

    @Override
    public void pumpEvents(Task task) {
        if (task == null) {
            return;
        }
        EventQueue eventQueue = this.getEventQueue();
        while (!task.isCompleted()) {
            try {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                if (this.filter != null && !this.filter.accept(aWTEvent)) continue;
                try {
                    this.dispatchEvent(eventQueue, aWTEvent);
                }
                catch (Throwable throwable) {
                    this.handleThrowable(throwable);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected void dispatchEvent(EventQueue eventQueue, AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else {
            System.err.println("[JDK13QueueEventPump] Unable to dispatch event " + aWTEvent);
        }
    }

    protected void handleThrowable(Throwable throwable) {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.awt.exception.handler");
            }
        });
        if (string != null) {
            try {
                Object obj = Thread.currentThread().getContextClassLoader().loadClass(string).newInstance();
                Method method = obj.getClass().getMethod("handle", Throwable.class);
                method.invoke(obj, throwable);
                return;
            }
            catch (Throwable throwable2) {
                System.err.println("[JDK13QueueEventPump] Exception occurred while invoking AWT exception handler: " + throwable2);
            }
        }
        System.err.println("[JDK13QueueEventPump] Exception occurred during event dispatching:");
        throwable.printStackTrace();
    }

    private EventQueue getEventQueue() {
        return (EventQueue)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
        });
    }
}

