/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFontSubSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class TrueTypeFont
extends BaseFont {
    static final String[] codePages = new String[]{"1252 Latin 1", "1250 Latin 2: Eastern Europe", "1251 Cyrillic", "1253 Greek", "1254 Turkish", "1255 Hebrew", "1256 Arabic", "1257 Windows Baltic", "1258 Vietnamese", null, null, null, null, null, null, null, "874 Thai", "932 JIS/Japan", "936 Chinese: Simplified chars--PRC and Singapore", "949 Korean Wansung", "950 Chinese: Traditional chars--Taiwan and Hong Kong", "1361 Korean Johab", null, null, null, null, null, null, null, "Macintosh Character Set (US Roman)", "OEM Character Set", "Symbol Character Set", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "869 IBM Greek", "866 MS-DOS Russian", "865 MS-DOS Nordic", "864 Arabic", "863 MS-DOS Canadian French", "862 Hebrew", "861 MS-DOS Icelandic", "860 MS-DOS Portuguese", "857 IBM Turkish", "855 IBM Cyrillic; primarily Russian", "852 Latin 2", "775 MS-DOS Baltic", "737 Greek; former 437 G", "708 Arabic; ASMO 708", "850 WE/Latin 1", "437 US"};
    protected boolean justNames = false;
    protected HashMap tables;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected boolean cff = false;
    protected int cffOffset;
    protected int cffLength;
    protected int directoryOffset;
    protected String ttcIndex;
    protected String style = "";
    protected FontHeader head = new FontHeader();
    protected HorizontalHeader hhea = new HorizontalHeader();
    protected WindowsMetrics os_2 = new WindowsMetrics();
    protected int[] GlyphWidths;
    protected int[][] bboxes;
    protected HashMap cmap10;
    protected HashMap cmap31;
    protected IntHashtable kerning = new IntHashtable();
    protected String fontName;
    protected String[][] fullName;
    protected String[][] familyName;
    protected double italicAngle;
    protected boolean isFixedPitch = false;

    protected TrueTypeFont() {
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray) throws DocumentException, IOException {
        this(string, string2, bl, byArray, false);
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray, boolean bl2) throws DocumentException, IOException {
        this.justNames = bl2;
        String string3 = TrueTypeFont.getBaseName(string);
        String string4 = TrueTypeFont.getTTCName(string3);
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string4;
        this.fontType = 1;
        this.ttcIndex = "";
        if (string4.length() < string3.length()) {
            this.ttcIndex = string3.substring(string4.length() + 1);
        }
        if (this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc")) {
            this.process(byArray);
            if (!bl2 && this.embedded && this.os_2.fsType == 2) {
                throw new DocumentException(this.fileName + this.style + " cannot be embedded due to licensing restrictions.");
            }
        } else {
            throw new DocumentException(this.fileName + this.style + " is not a TTF, OTF or TTC font file.");
        }
        if (!this.encoding.startsWith("#")) {
            PdfEncodings.convertToBytes(" ", string2);
        }
        this.createEncoding();
    }

    protected static String getTTCName(String string) {
        int n = string.toLowerCase().indexOf(".ttc,");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n + 4);
    }

    void fillTables() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("hhea");
        if (nArray == null) {
            throw new DocumentException("Table 'hhea' does not exist " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("OS/2");
        if (nArray == null) {
            throw new DocumentException("Table 'OS/2' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        int n = this.rf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        if (this.os_2.sTypoDescender > 0) {
            this.os_2.sTypoDescender = -this.os_2.sTypoDescender;
        }
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (n > 0) {
            this.os_2.ulCodePageRange1 = this.rf.readInt();
            this.os_2.ulCodePageRange2 = this.rf.readInt();
        }
        if (n > 1) {
            this.rf.skipBytes(2);
            this.os_2.sCapHeight = this.rf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
        nArray = (int[])this.tables.get("post");
        if (nArray == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(nArray[0] + 4);
        short s = this.rf.readShort();
        int n2 = this.rf.readUnsignedShort();
        this.italicAngle = (double)s + (double)n2 / 16384.0;
        this.rf.skipBytes(4);
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n = this.rf.readUnsignedShort();
        int n2 = this.rf.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n3 = this.rf.readUnsignedShort();
            int n4 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            if (n6 != 6) continue;
            this.rf.seek(nArray[0] + n2 + n8);
            if (n3 == 0 || n3 == 3) {
                return this.readUnicodeString(n7);
            }
            return this.readStandardString(n7);
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '-');
    }

    String[][] getNames(int n) throws DocumentException, IOException {
        int n2;
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n3 = this.rf.readUnsignedShort();
        int n4 = this.rf.readUnsignedShort();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < n3; ++i) {
            n2 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            if (n7 != n) continue;
            int n10 = this.rf.getFilePointer();
            this.rf.seek(nArray[0] + n4 + n9);
            String string = n2 == 0 || n2 == 3 || n2 == 2 && n5 == 1 ? this.readUnicodeString(n8) : this.readStandardString(n8);
            arrayList.add(new String[]{String.valueOf(n2), String.valueOf(n5), String.valueOf(n6), string});
            this.rf.seek(n10);
        }
        String[][] stringArray = new String[arrayList.size()][];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray[n2] = (String[])arrayList.get(n2);
        }
        return stringArray;
    }

    void checkCff() {
        int[] nArray = (int[])this.tables.get("CFF ");
        if (nArray != null) {
            this.cff = true;
            this.cffOffset = nArray[0];
            this.cffLength = nArray[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(byte[] byArray) throws DocumentException, IOException {
        this.tables = new HashMap();
        try {
            int n;
            int n2;
            this.rf = byArray == null ? new RandomAccessFileOrArray(this.fileName) : new RandomAccessFileOrArray(byArray);
            if (this.ttcIndex.length() > 0) {
                n2 = Integer.parseInt(this.ttcIndex);
                if (n2 < 0) {
                    throw new DocumentException("The font index for " + this.fileName + " must be positive.");
                }
                String string = this.readStandardString(4);
                if (!string.equals("ttcf")) {
                    throw new DocumentException(this.fileName + " is not a valid TTC file.");
                }
                this.rf.skipBytes(4);
                n = this.rf.readInt();
                if (n2 >= n) {
                    throw new DocumentException("The font index for " + this.fileName + " must be between 0 and " + (n - 1) + ". It was " + n2 + ".");
                }
                this.rf.skipBytes(n2 * 4);
                this.directoryOffset = this.rf.readInt();
            }
            this.rf.seek(this.directoryOffset);
            n2 = this.rf.readInt();
            if (n2 != 65536 && n2 != 0x4F54544F) {
                throw new DocumentException(this.fileName + " is not a valid TTF or OTF file.");
            }
            int n3 = this.rf.readUnsignedShort();
            this.rf.skipBytes(6);
            for (n = 0; n < n3; ++n) {
                String string = this.readStandardString(4);
                this.rf.skipBytes(4);
                int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                this.tables.put(string, nArray);
            }
            this.checkCff();
            this.fontName = this.getBaseFont();
            this.fullName = this.getNames(4);
            this.familyName = this.getNames(1);
            if (!this.justNames) {
                this.fillTables();
                this.readGlyphWidths();
                this.readCMaps();
                this.readKerning();
                this.readBbox();
                this.GlyphWidths = null;
            }
        }
        finally {
            if (this.rf != null) {
                this.rf.close();
                if (!this.embedded) {
                    this.rf = null;
                }
            }
        }
    }

    protected String readStandardString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.rf.readFully(byArray);
        try {
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected String readUnicodeString(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        n /= 2;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.rf.readChar());
        }
        return stringBuffer.toString();
    }

    protected void readGlyphWidths() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("hmtx");
        if (nArray == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        for (int i = 0; i < this.hhea.numberOfHMetrics; ++i) {
            this.GlyphWidths[i] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
        }
    }

    protected int getGlyphWidth(int n) {
        if (n >= this.GlyphWidths.length) {
            n = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[n];
    }

    private void readBbox() throws DocumentException, IOException {
        int n;
        int[] nArray;
        int n2;
        int[] nArray2 = (int[])this.tables.get("head");
        if (nArray2 == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray2[0] + 51);
        boolean bl = this.rf.readUnsignedShort() == 0;
        nArray2 = (int[])this.tables.get("loca");
        if (nArray2 == null) {
            return;
        }
        this.rf.seek(nArray2[0]);
        if (bl) {
            n2 = nArray2[1] / 2;
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.rf.readUnsignedShort() * 2;
            }
        } else {
            n2 = nArray2[1] / 4;
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.rf.readInt();
            }
        }
        if ((nArray2 = (int[])this.tables.get("glyf")) == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName + this.style);
        }
        n2 = nArray2[0];
        this.bboxes = new int[nArray.length - 1][];
        for (n = 0; n < nArray.length - 1; ++n) {
            int n3 = nArray[n];
            if (n3 == nArray[n + 1]) continue;
            this.rf.seek(n2 + n3 + 2);
            this.bboxes[n] = new int[]{this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm};
        }
    }

    void readCMaps() throws DocumentException, IOException {
        int n;
        int[] nArray = (int[])this.tables.get("cmap");
        if (nArray == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.rf.skipBytes(2);
        int n2 = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readInt();
            if (n6 == 3 && n7 == 0) {
                this.fontSpecific = true;
                n5 = n8;
            } else if (n6 == 3 && n7 == 1) {
                n4 = n8;
            }
            if (n6 != 1 || n7 != 0) continue;
            n3 = n8;
        }
        if (n3 > 0) {
            this.rf.seek(nArray[0] + n3);
            n = this.rf.readUnsignedShort();
            switch (n) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (n4 > 0) {
            this.rf.seek(nArray[0] + n4);
            n = this.rf.readUnsignedShort();
            if (n == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
        if (n5 > 0) {
            this.rf.seek(nArray[0] + n5);
            n = this.rf.readUnsignedShort();
            if (n == 4) {
                this.cmap10 = this.readFormat4();
            }
        }
    }

    HashMap readFormat0() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        for (int i = 0; i < 256; ++i) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(i), nArray);
        }
        return hashMap;
    }

    HashMap readFormat4() throws IOException {
        int n;
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n2 = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int n3 = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.rf.readUnsignedShort();
        }
        this.rf.skipBytes(2);
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = this.rf.readUnsignedShort();
        }
        int[] nArray3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray3[i] = this.rf.readUnsignedShort();
        }
        int[] nArray4 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray4[i] = this.rf.readUnsignedShort();
        }
        int[] nArray5 = new int[n2 / 2 - 8 - n3 * 4];
        for (n = 0; n < nArray5.length; ++n) {
            nArray5[n] = this.rf.readUnsignedShort();
        }
        for (n = 0; n < n3; ++n) {
            for (int i = nArray2[n]; i <= nArray[n] && i != 65535; ++i) {
                int[] nArray6;
                int n4;
                if (nArray4[n] == 0) {
                    n4 = i + nArray3[n] & 0xFFFF;
                } else {
                    int n5 = n + nArray4[n] / 2 - n3 + i - nArray2[n];
                    if (n5 >= nArray5.length) continue;
                    n4 = nArray5[n5] + nArray3[n] & 0xFFFF;
                }
                nArray6 = new int[]{n4, this.getGlyphWidth(nArray6[0])};
                hashMap.put(new Integer(this.fontSpecific ? ((i & 0xFF00) == 61440 ? i & 0xFF : i) : i), nArray6);
            }
        }
        return hashMap;
    }

    HashMap readFormat6() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n = this.rf.readUnsignedShort();
        int n2 = this.rf.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(i + n), nArray);
        }
        return hashMap;
    }

    void readKerning() throws IOException {
        int[] nArray = (int[])this.tables.get("kern");
        if (nArray == null) {
            return;
        }
        this.rf.seek(nArray[0] + 2);
        int n = this.rf.readUnsignedShort();
        int n2 = nArray[0] + 4;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            this.rf.seek(n2 += n3);
            this.rf.skipBytes(2);
            n3 = this.rf.readUnsignedShort();
            int n4 = this.rf.readUnsignedShort();
            if ((n4 & 0xFFF7) != 1) continue;
            int n5 = this.rf.readUnsignedShort();
            this.rf.skipBytes(6);
            for (int j = 0; j < n5; ++j) {
                int n6 = this.rf.readInt();
                int n7 = this.rf.readShort() * 1000 / this.head.unitsPerEm;
                this.kerning.put(n6, n7);
            }
        }
    }

    @Override
    public int getKerning(char c, char c2) {
        int[] nArray = this.getMetricsTT(c);
        if (nArray == null) {
            return 0;
        }
        int n = nArray[0];
        nArray = this.getMetricsTT(c2);
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray[0];
        return this.kerning.get((n << 16) + n2);
    }

    @Override
    int getRawWidth(int n, String string) {
        HashMap hashMap = null;
        hashMap = string == null || this.cmap31 == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return 0;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n));
        if (nArray == null) {
            return 0;
        }
        return nArray[1];
    }

    protected PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference, String string) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        pdfDictionary.put(PdfName.ASCENT, new PdfNumber(this.os_2.sTypoAscender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(PdfName.CAPHEIGHT, new PdfNumber(this.os_2.sCapHeight * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(PdfName.DESCENT, new PdfNumber(this.os_2.sTypoDescender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(PdfName.FONTBBOX, new PdfRectangle(this.head.xMin * 1000 / this.head.unitsPerEm, this.head.yMin * 1000 / this.head.unitsPerEm, this.head.xMax * 1000 / this.head.unitsPerEm, this.head.yMax * 1000 / this.head.unitsPerEm));
        if (this.cff) {
            if (this.encoding.startsWith("Identity-")) {
                pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.fontName + "-" + this.encoding));
            } else {
                pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.fontName + this.style));
            }
        } else {
            pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.fontName + this.style));
        }
        pdfDictionary.put(PdfName.ITALICANGLE, new PdfNumber(this.italicAngle));
        pdfDictionary.put(PdfName.STEMV, new PdfNumber(80));
        if (pdfIndirectReference != null) {
            if (this.cff) {
                pdfDictionary.put(PdfName.FONTFILE3, pdfIndirectReference);
            } else {
                pdfDictionary.put(PdfName.FONTFILE2, pdfIndirectReference);
            }
        }
        int n = 0;
        if (this.isFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if ((this.head.macStyle & 2) != 0) {
            n |= 0x40;
        }
        if ((this.head.macStyle & 1) != 0) {
            n |= 0x40000;
        }
        pdfDictionary.put(PdfName.FLAGS, new PdfNumber(n));
        return pdfDictionary;
    }

    protected PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, String string, int n, int n2, byte[] byArray) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        if (this.cff) {
            pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.fontName + this.style));
        } else {
            pdfDictionary.put(PdfName.SUBTYPE, PdfName.TRUETYPE);
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + this.style));
        }
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + this.style));
        if (!this.fontSpecific) {
            for (int i = n; i <= n2; ++i) {
                if (this.differences[i].equals(".notdef")) continue;
                n = i;
                break;
            }
            if (this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman")) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.ENCODING);
                PdfArray pdfArray = new PdfArray();
                boolean bl = true;
                for (int i = n; i <= n2; ++i) {
                    if (byArray[i] != 0) {
                        if (bl) {
                            pdfArray.add(new PdfNumber(i));
                            bl = false;
                        }
                        pdfArray.add(new PdfName(this.differences[i]));
                        continue;
                    }
                    bl = true;
                }
                pdfDictionary2.put(PdfName.DIFFERENCES, pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        pdfDictionary.put(PdfName.FIRSTCHAR, new PdfNumber(n));
        pdfDictionary.put(PdfName.LASTCHAR, new PdfNumber(n2));
        PdfArray pdfArray = new PdfArray();
        for (int i = n; i <= n2; ++i) {
            if (byArray[i] == 0) {
                pdfArray.add(new PdfNumber(0));
                continue;
            }
            pdfArray.add(new PdfNumber(this.widths[i]));
        }
        pdfDictionary.put(PdfName.WIDTHS, pdfArray);
        if (pdfIndirectReference != null) {
            pdfDictionary.put(PdfName.FONTDESCRIPTOR, pdfIndirectReference);
        }
        return pdfDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getFullFont() throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = null;
        try {
            randomAccessFileOrArray = new RandomAccessFileOrArray(this.rf);
            randomAccessFileOrArray.reOpen();
            byte[] byArray = new byte[randomAccessFileOrArray.length()];
            randomAccessFileOrArray.readFully(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            try {
                if (randomAccessFileOrArray != null) {
                    randomAccessFileOrArray.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected static int[] compactRanges(ArrayList arrayList) {
        int n;
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        for (n = 0; n < arrayList.size(); ++n) {
            int[] nArray = (int[])arrayList.get(n);
            for (int i = 0; i < nArray.length; i += 2) {
                arrayList2.add(new int[]{Math.max(0, Math.min(nArray[i], nArray[i + 1])), Math.min(65535, Math.max(nArray[i], nArray[i + 1]))});
            }
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            for (int i = n + 1; i < arrayList2.size(); ++i) {
                int[] nArray;
                int[] nArray2 = (int[])arrayList2.get(n);
                if ((nArray2[0] < (nArray = (int[])arrayList2.get(i))[0] || nArray2[0] > nArray[1]) && (nArray2[1] < nArray[0] || nArray2[0] > nArray[1])) continue;
                nArray2[0] = Math.min(nArray2[0], nArray[0]);
                nArray2[1] = Math.max(nArray2[1], nArray[1]);
                arrayList2.remove(i);
                --i;
            }
        }
        int[] nArray = new int[arrayList2.size() * 2];
        for (int i = 0; i < arrayList2.size(); ++i) {
            int[] nArray3 = (int[])arrayList2.get(i);
            nArray[i * 2] = nArray3[0];
            nArray[i * 2 + 1] = nArray3[1];
        }
        return nArray;
    }

    protected void addRangeUni(HashMap hashMap, boolean bl, boolean bl2) {
        if (!(bl2 || this.subsetRanges == null && this.directoryOffset <= 0)) {
            int[] nArray;
            int[] nArray2;
            if (this.subsetRanges == null && this.directoryOffset > 0) {
                int[] nArray3 = new int[2];
                nArray3[0] = 0;
                nArray2 = nArray3;
                nArray3[1] = 65535;
            } else {
                nArray2 = nArray = TrueTypeFont.compactRanges(this.subsetRanges);
            }
            HashMap hashMap2 = !this.fontSpecific && this.cmap31 != null ? this.cmap31 : (this.fontSpecific && this.cmap10 != null ? this.cmap10 : (this.cmap31 != null ? this.cmap31 : this.cmap10));
            for (Map.Entry entry : hashMap2.entrySet()) {
                int[] nArray4;
                int[] nArray5 = (int[])entry.getValue();
                Integer n = new Integer(nArray5[0]);
                if (hashMap.containsKey(n)) continue;
                int n2 = (Integer)entry.getKey();
                boolean bl3 = true;
                for (int i = 0; i < nArray.length; i += 2) {
                    if (n2 < nArray[i] || n2 > nArray[i + 1]) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) continue;
                if (bl) {
                    int[] nArray6 = new int[3];
                    nArray6[0] = nArray5[0];
                    nArray6[1] = nArray5[1];
                    nArray4 = nArray6;
                    nArray6[2] = n2;
                } else {
                    nArray4 = null;
                }
                hashMap.put(n, nArray4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        boolean bl;
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        boolean bl2 = bl = (Boolean)objectArray[3] != false && this.subset;
        if (!bl) {
            n = 0;
            n2 = byArray.length - 1;
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 1;
            }
        }
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        String string = "";
        if (this.embedded) {
            if (this.cff) {
                RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(this.rf);
                byte[] byArray2 = new byte[this.cffLength];
                try {
                    randomAccessFileOrArray.reOpen();
                    randomAccessFileOrArray.seek(this.cffOffset);
                    randomAccessFileOrArray.readFully(byArray2);
                }
                finally {
                    try {
                        randomAccessFileOrArray.close();
                    }
                    catch (Exception exception) {}
                }
                pdfDictionary = new BaseFont.StreamFont(byArray2, "Type1C");
                pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
                pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
            } else {
                Object object;
                if (bl) {
                    string = TrueTypeFont.createSubsetPrefix();
                }
                HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                for (int i = n; i <= n2; ++i) {
                    if (byArray[i] == 0) continue;
                    object = null;
                    if (this.specialMap != null) {
                        int[] nArray = GlyphList.nameToUnicode(this.differences[i]);
                        if (nArray != null) {
                            object = this.getMetricsTT(nArray[0]);
                        }
                    } else {
                        object = this.fontSpecific ? this.getMetricsTT(i) : this.getMetricsTT(this.unicodeDifferences[i]);
                    }
                    if (object == null) continue;
                    hashMap.put(new Integer(object[0]), null);
                }
                this.addRangeUni(hashMap, false, bl);
                byte[] byArray3 = null;
                if (bl || this.directoryOffset != 0 || this.subsetRanges != null) {
                    object = new TrueTypeFontSubSet(this.fileName, new RandomAccessFileOrArray(this.rf), hashMap, this.directoryOffset, true, !bl);
                    byArray3 = object.process();
                } else {
                    byArray3 = this.getFullFont();
                }
                object = new int[]{byArray3.length};
                pdfDictionary = new BaseFont.StreamFont(byArray3, (int[])object);
                pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
                pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
            }
        }
        if ((pdfDictionary = this.getFontDescriptor(pdfIndirectReference2, string)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, string, n, n2, byArray);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    @Override
    public float getFontDescriptor(int n, float f) {
        switch (n) {
            case 1: {
                return (float)this.os_2.sTypoAscender * f / (float)this.head.unitsPerEm;
            }
            case 2: {
                return (float)this.os_2.sCapHeight * f / (float)this.head.unitsPerEm;
            }
            case 3: {
                return (float)this.os_2.sTypoDescender * f / (float)this.head.unitsPerEm;
            }
            case 4: {
                return (float)this.italicAngle;
            }
            case 5: {
                return f * (float)this.head.xMin / (float)this.head.unitsPerEm;
            }
            case 6: {
                return f * (float)this.head.yMin / (float)this.head.unitsPerEm;
            }
            case 7: {
                return f * (float)this.head.xMax / (float)this.head.unitsPerEm;
            }
            case 8: {
                return f * (float)this.head.yMax / (float)this.head.unitsPerEm;
            }
            case 9: {
                return f * (float)this.hhea.Ascender / (float)this.head.unitsPerEm;
            }
            case 10: {
                return f * (float)this.hhea.Descender / (float)this.head.unitsPerEm;
            }
            case 11: {
                return f * (float)this.hhea.LineGap / (float)this.head.unitsPerEm;
            }
            case 12: {
                return f * (float)this.hhea.advanceWidthMax / (float)this.head.unitsPerEm;
            }
        }
        return 0.0f;
    }

    public int[] getMetricsTT(int n) {
        if (!this.fontSpecific && this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(n));
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(n));
        }
        if (this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(n));
        }
        if (this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(n));
        }
        return null;
    }

    @Override
    public String getPostscriptFontName() {
        return this.fontName;
    }

    @Override
    public String[] getCodePagesSupported() {
        long l = ((long)this.os_2.ulCodePageRange2 << 32) + ((long)this.os_2.ulCodePageRange1 & 0xFFFFFFFFL);
        int n = 0;
        long l2 = 1L;
        for (int i = 0; i < 64; ++i) {
            if ((l & l2) != 0L && codePages[i] != null) {
                ++n;
            }
            l2 <<= 1;
        }
        String[] stringArray = new String[n];
        n = 0;
        l2 = 1L;
        for (int i = 0; i < 64; ++i) {
            if ((l & l2) != 0L && codePages[i] != null) {
                stringArray[n++] = codePages[i];
            }
            l2 <<= 1;
        }
        return stringArray;
    }

    @Override
    public String[][] getFullFontName() {
        return this.fullName;
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.familyName;
    }

    @Override
    public boolean hasKernPairs() {
        return this.kerning.size() > 0;
    }

    @Override
    public void setPostscriptFontName(String string) {
        this.fontName = string;
    }

    @Override
    public boolean setKerning(char c, char c2, int n) {
        int[] nArray = this.getMetricsTT(c);
        if (nArray == null) {
            return false;
        }
        int n2 = nArray[0];
        nArray = this.getMetricsTT(c2);
        if (nArray == null) {
            return false;
        }
        int n3 = nArray[0];
        this.kerning.put((n2 << 16) + n3, n);
        return true;
    }

    @Override
    protected int[] getRawCharBBox(int n, String string) {
        HashMap hashMap = null;
        hashMap = string == null || this.cmap31 == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return null;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n));
        if (nArray == null || this.bboxes == null) {
            return null;
        }
        return this.bboxes[nArray[0]];
    }

    protected static class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }

    protected static class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    protected static class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;

        protected FontHeader() {
        }
    }
}

