/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.codec.postscript.MetaDoPS;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class ImgPostscript
extends Image {
    ImgPostscript(Image image) {
        super(image);
    }

    public ImgPostscript(byte[] byArray, float f, float f2) throws IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
        this.urx = f;
        this.ury = f2;
    }

    public ImgPostscript(URL uRL) throws IOException {
        super(uRL);
        this.processParameters();
    }

    public ImgPostscript(String string) throws MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public ImgPostscript(byte[] byArray) throws IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws IOException {
        this.type = 35;
        this.originalType = 7;
        InputStream inputStream = null;
        try {
            CharSequence charSequence;
            inputStream = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            String string = null;
            String string2 = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (((Reader)bufferedReader).ready()) {
                char c;
                charSequence = new StringBuffer();
                while ((c = (char)((Reader)bufferedReader).read()) != '\n' && c != '\r') {
                    ((StringBuffer)charSequence).append(c);
                }
                if (((StringBuffer)charSequence).toString().startsWith("%%BoundingBox:")) {
                    string = ((StringBuffer)charSequence).toString();
                }
                if (((StringBuffer)charSequence).toString().startsWith("%%TemplateBox:")) {
                    string2 = ((StringBuffer)charSequence).toString();
                }
                if (!((StringBuffer)charSequence).toString().startsWith("%%EndComments") && (((StringBuffer)charSequence).toString().startsWith("%%") || ((StringBuffer)charSequence).toString().startsWith("%!"))) continue;
                break;
            }
            if (string == null) {
                this.scaledHeight = PageSize.A4.height();
                this.setTop(this.scaledHeight);
                this.scaledWidth = PageSize.A4.width();
                this.setRight(this.scaledWidth);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ": \r\n");
            stringTokenizer.nextElement();
            charSequence = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            int n = Integer.parseInt((String)charSequence);
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            int n4 = Integer.parseInt(string5);
            boolean bl = true;
            this.dpiX = 72;
            this.dpiY = 72;
            this.scaledHeight = (float)(n4 - n2) / (float)bl * 1.0f;
            this.setTop(n4);
            this.scaledWidth = (float)(n3 - n) / (float)bl * 1.0f;
            this.setRight(n3);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPostscript(PdfTemplate pdfTemplate) throws IOException {
        this.setTemplateData(pdfTemplate);
        pdfTemplate.setWidth(this.width());
        pdfTemplate.setHeight(this.height());
        try (InputStream inputStream = null;){
            inputStream = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            MetaDoPS metaDoPS = new MetaDoPS(inputStream, pdfTemplate);
            metaDoPS.readAll();
        }
    }
}

