/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.FilterIterator;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.filter.Filter;

public class Document
implements Parent {
    private static final String CVS_ID = "@(#) $RCSfile: Document.java,v $ $Revision: 1.84 $ $Date: 2004/08/31 21:47:51 $ $Name: jdom_1_0 $";
    ContentList content = new ContentList(this);
    protected String baseURI = null;
    private HashMap propertyMap = null;

    public Document() {
    }

    public Document(Element element, DocType docType, String string) {
        if (element != null) {
            this.setRootElement(element);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (string != null) {
            this.setBaseURI(string);
        }
    }

    public Document(Element element, DocType docType) {
        this(element, docType, null);
    }

    public Document(Element element) {
        this(element, null, null);
    }

    public Document(List list) {
        this.setContent(list);
    }

    public int getContentSize() {
        return this.content.size();
    }

    public int indexOf(Content content) {
        return this.content.indexOf(content);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(n);
    }

    public Document setRootElement(Element element) {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            this.content.add(element);
        } else {
            this.content.set(n, element);
        }
        return this;
    }

    public Element detachRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            return null;
        }
        return (Element)this.removeContent(n);
    }

    public DocType getDocType() {
        int n = this.content.indexOfDocType();
        if (n < 0) {
            return null;
        }
        return (DocType)this.content.get(n);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int n = this.content.indexOfDocType();
            if (n >= 0) {
                this.content.remove(n);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int n = this.content.indexOfDocType();
        if (n < 0) {
            this.content.add(0, docType);
        } else {
            this.content.set(n, docType);
        }
        return this;
    }

    public Document addContent(Content content) {
        this.content.add(content);
        return this;
    }

    public Document addContent(Collection collection) {
        this.content.addAll(collection);
        return this;
    }

    public Document addContent(int n, Content content) {
        this.content.add(n, content);
        return this;
    }

    public Document addContent(int n, Collection collection) {
        this.content.addAll(n, collection);
        return this;
    }

    public List cloneContent() {
        int n = this.getContentSize();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Content content = this.getContent(n2);
            arrayList.add(content.clone());
            ++n2;
        }
        return arrayList;
    }

    public Content getContent(int n) {
        return (Content)this.content.get(n);
    }

    public List getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    public List getContent(Filter filter) {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content.getView(filter);
    }

    public List removeContent() {
        ArrayList arrayList = new ArrayList(this.content);
        this.content.clear();
        return arrayList;
    }

    public List removeContent(Filter filter) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Iterator iterator = this.content.getView(filter).iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            arrayList.add(content);
            iterator.remove();
        }
        return arrayList;
    }

    public Document setContent(Collection collection) {
        this.content.clearAndSet(collection);
        return this;
    }

    public final void setBaseURI(String string) {
        this.baseURI = string;
    }

    public final String getBaseURI() {
        return this.baseURI;
    }

    public Document setContent(int n, Content content) {
        this.content.set(n, content);
        return this;
    }

    public Document setContent(int n, Collection collection) {
        this.content.remove(n);
        this.content.addAll(n, collection);
        return this;
    }

    public boolean removeContent(Content content) {
        return this.content.remove(content);
    }

    public Content removeContent(int n) {
        return (Content)this.content.remove(n);
    }

    public Document setContent(Content content) {
        this.content.clear();
        this.content.add(content);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringBuffer.append(docType.toString()).append(", ");
        } else {
            stringBuffer.append(" No DOCTYPE declaration, ");
        }
        Element element = this.getRootElement();
        if (element != null) {
            stringBuffer.append("Root is ").append(element.toString());
        } else {
            stringBuffer.append(" No root element");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Document document = null;
        try {
            document = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        document.content = new ContentList(document);
        int n = 0;
        while (n < this.content.size()) {
            Content content;
            Object object = this.content.get(n);
            if (object instanceof Element) {
                content = (Element)((Element)object).clone();
                document.content.add(content);
            } else if (object instanceof Comment) {
                content = (Comment)((Comment)object).clone();
                document.content.add(content);
            } else if (object instanceof ProcessingInstruction) {
                content = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                document.content.add(content);
            } else if (object instanceof DocType) {
                content = (DocType)((DocType)object).clone();
                document.content.add(content);
            }
            ++n;
        }
        return document;
    }

    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    public Parent getParent() {
        return null;
    }

    public Document getDocument() {
        return this;
    }

    public void setProperty(String string, Object object) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.get(string);
    }
}

