/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import com.jgoodies.forms.builder.I15dPanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.EditLogico;
import serpro.ppgd.gui.PPGDComponentFactory;

public final class PPGDFormBuilder
extends I15dPanelBuilder {
    private RowSpec lineGapSpec = FormFactory.LINE_GAP_ROWSPEC;
    private RowSpec paragraphGapSpec = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    private int leadingColumnOffset = 0;
    private boolean rowGroupingEnabled = false;

    public PPGDFormBuilder(FormLayout formLayout) {
        this(new JPanel(), formLayout);
    }

    public PPGDFormBuilder(JPanel jPanel, FormLayout formLayout) {
        this(jPanel, formLayout, null);
    }

    public PPGDFormBuilder(FormLayout formLayout, ResourceBundle resourceBundle) {
        this(new JPanel(), formLayout, resourceBundle);
    }

    public PPGDFormBuilder(JPanel jPanel, FormLayout formLayout, ResourceBundle resourceBundle) {
        super(formLayout, resourceBundle, jPanel);
        this.setComponentFactory(PPGDComponentFactory.getInstance());
    }

    public void setLineGapSize(ConstantSize constantSize) {
        RowSpec rowSpec;
        this.lineGapSpec = rowSpec = FormFactory.createGapRowSpec(constantSize);
    }

    public RowSpec getLineGapSpec() {
        return this.lineGapSpec;
    }

    public void setParagraphGapSize(ConstantSize constantSize) {
        RowSpec rowSpec;
        this.paragraphGapSpec = rowSpec = FormFactory.createGapRowSpec(constantSize);
    }

    public int getLeadingColumnOffset() {
        return this.leadingColumnOffset;
    }

    public void setLeadingColumnOffset(int n) {
        this.leadingColumnOffset = n;
    }

    public boolean isRowGroupingEnabled() {
        return this.rowGroupingEnabled;
    }

    public void setRowGroupingEnabled(boolean bl) {
        this.rowGroupingEnabled = bl;
    }

    public void append(Component component) {
        this.append(component, 1);
    }

    public void append(Component component, int n, boolean bl) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.lineGapSpec);
        this.ensureHasComponentLine();
        if (bl) {
            int n2 = this.getColumn();
            int n3 = this.getColumnCount();
            n = n3 - n2 + 1;
        }
        this.add(component, this.createLeftAdjustedConstraints(n));
        this.nextColumn(n + 1);
    }

    public void append(Component component, int n) {
        this.append(component, n, false);
    }

    public void append(Component component, Component component2) {
        this.append(component);
        this.append(component2);
    }

    public void append(Component component, Component component2, Component component3) {
        this.append(component);
        this.append(component2);
        this.append(component3);
    }

    public JLabel append(String string) {
        JLabel jLabel = this.getComponentFactory().createLabel(string);
        this.append(jLabel);
        return jLabel;
    }

    public JLabel append(String string, Component component) {
        return this.append(string, component, 1);
    }

    public JLabel append(String string, Component component, int n) {
        JLabel jLabel = this.append(string);
        jLabel.setLabelFor(component);
        this.append(component, n);
        return jLabel;
    }

    public JLabel append(JLabel jLabel, Component component, int n) {
        this.append(jLabel);
        jLabel.setLabelFor(component);
        this.append(component, n);
        return jLabel;
    }

    public void appendNoMessage(EditCampo editCampo) {
        this.append((Component)editCampo.getRotulo(), (Component)editCampo.getComponenteEditor());
    }

    public void appendNoMessage(EditCampo editCampo, int n) {
        this.append(editCampo.getRotulo(), (Component)editCampo.getComponenteEditor(), n);
    }

    public void append(EditCampo editCampo, int n) {
        JPanel jPanel = this.createMessagePanel(editCampo);
        this.append(editCampo.getRotulo(), (Component)jPanel, n);
    }

    public void appendLabel(EditCampo editCampo, int n) {
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel(new FormLayout("p:grow,center:MAX(p;8dlu)", "fill:p"));
        jPanel.add((Component)editCampo.getRotulo(), cellConstraints.xy(1, 1));
        jPanel.add((Component)editCampo.getSimbolo(), cellConstraints.xy(2, 1));
        this.append((Component)jPanel, n);
    }

    public void appendEditor(EditCampo editCampo, int n) {
        JPanel jPanel = this.createMessagePanel(editCampo);
        this.append((Component)jPanel, n);
    }

    public void appendEditorNoMessage(EditCampo editCampo) {
        this.append(editCampo.getComponenteEditor());
    }

    public void appendEditorNoMessage(EditCampo editCampo, int n) {
        this.append((Component)editCampo.getComponenteEditor(), n);
    }

    public void appendSingleCell(EditCampo editCampo, int n) {
        JPanel jPanel = this.createAllPanel(editCampo);
        this.append((Component)jPanel, n);
    }

    public void appendSingleCellToEOL(EditCampo editCampo) {
        JPanel jPanel = this.createAllPanel(editCampo);
        this.append((Component)jPanel, 0, true);
    }

    public JLabel appendTitulo(String string) {
        return this.appendTitulo(string, 0);
    }

    public JLabel appendTitulo(String string, boolean bl) {
        return this.appendTitulo(string, 0, bl);
    }

    public JLabel appendTitulo(String string, int n) {
        return this.appendTitulo(string, n, false);
    }

    public JLabel appendTitulo(String string, int n, boolean bl) {
        JLabel jLabel = new JLabel(string);
        if (n != 0) {
            this.append((Component)jLabel, n);
        } else {
            this.append(jLabel);
        }
        return jLabel;
    }

    private JPanel createMessagePanel(EditCampo editCampo) {
        FormLayout formLayout = new FormLayout("fill:default:grow, center:8dlu", "fill:p");
        JPanel jPanel = new JPanel(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)editCampo.getComponenteEditor(), cellConstraints.xy(1, 1));
        jPanel.add((Component)editCampo.getButtonMensagem(), cellConstraints.xy(2, 1));
        jPanel.setOpaque(false);
        return jPanel;
    }

    public JPanel createAllPanel(EditCampo editCampo) {
        FormLayout formLayout = new FormLayout("left:pref, 2dlu, fill:default:grow, center:8dlu", "fill:p");
        JPanel jPanel = new JPanel(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel2 = new JPanel(new FormLayout("p:grow,center:8dlu", "fill:p"));
        jPanel2.add((Component)editCampo.getRotulo(), cellConstraints.xy(1, 1));
        jPanel2.add((Component)editCampo.getSimbolo(), cellConstraints.xy(2, 1));
        jPanel.add((Component)jPanel2, cellConstraints.xy(1, 1));
        jPanel.add((Component)editCampo.getComponenteEditor(), cellConstraints.xy(3, 1));
        jPanel.add((Component)editCampo.getButtonMensagem(), cellConstraints.xy(4, 1));
        jPanel.setOpaque(false);
        return jPanel;
    }

    public void append(EditCampo editCampo) {
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel(new FormLayout("p:grow,center:MAX(8dlu;p)", "fill:p"));
        jPanel.add((Component)editCampo.getRotulo(), cellConstraints.xy(1, 1));
        jPanel.add((Component)editCampo.getSimbolo(), cellConstraints.xy(2, 1));
        this.append((Component)jPanel, (Component)this.createMessagePanel(editCampo));
    }

    public void appendToEOLNoMessage(EditCampo editCampo) {
        JLabel jLabel = this.append(editCampo.getInformacao().getNomeCampo());
        JComponent jComponent = editCampo.getComponenteEditor();
        jLabel.setLabelFor(jComponent);
        editCampo.setRotulo(jLabel);
        this.append((Component)jComponent, 0, true);
    }

    public void appendToEOL(EditCampo editCampo) {
        JLabel jLabel = this.append(editCampo.getInformacao().getNomeCampo());
        JPanel jPanel = this.createMessagePanel(editCampo);
        jLabel.setLabelFor(editCampo.getComponenteEditor());
        editCampo.setRotulo(jLabel);
        this.append((Component)jPanel, 0, true);
    }

    public void appendCenter(JComponent jComponent) {
        this.append((Component)this.createCenterPanel(jComponent), 0, true);
    }

    public JPanel createCenterPanel(JComponent jComponent) {
        FormLayout formLayout = new FormLayout("p:grow, center:p, p:grow", "p");
        JPanel jPanel = new JPanel(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)jComponent, cellConstraints.xy(2, 1));
        return jPanel;
    }

    public JLabel append(String string, Component component, Component component2) {
        JLabel jLabel = this.append(string, component);
        this.append(component2);
        return jLabel;
    }

    public void append(String string, Component component, Component component2, int n) {
        this.append(string, component);
        this.append(component2, n);
    }

    public JLabel append(String string, Component component, Component component2, Component component3) {
        JLabel jLabel = this.append(string, component, component2);
        this.append(component3);
        return jLabel;
    }

    public JLabel append(String string, Component component, Component component2, Component component3, Component component4) {
        JLabel jLabel = this.append(string, component, component2, component3);
        this.append(component4);
        return jLabel;
    }

    public JLabel appendI15d(String string) {
        return this.append(this.getI15dString(string));
    }

    public JLabel appendI15d(String string, Component component, int n) {
        JLabel jLabel = this.appendI15d(string);
        this.append(component, n);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component) {
        return this.appendI15d(string, component, 1);
    }

    public JLabel appendI15d(String string, Component component, boolean bl) {
        JLabel jLabel = this.appendI15d(string, component, 1);
        if (bl) {
            this.nextLine();
        }
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2) {
        JLabel jLabel = this.appendI15d(string, component);
        this.append(component2);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2, int n) {
        JLabel jLabel = this.appendI15d(string, component);
        this.append(component2, n);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2, Component component3) {
        JLabel jLabel = this.appendI15d(string, component, component2);
        this.append(component3);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2, Component component3, Component component4) {
        JLabel jLabel = this.appendI15d(string, component, component2, component3);
        this.append(component4);
        return jLabel;
    }

    public JLabel appendTitle(String string) {
        JLabel jLabel = this.getComponentFactory().createTitle(string);
        this.append(jLabel);
        return jLabel;
    }

    public JLabel appendI15dTitle(String string) {
        return this.appendTitle(this.getI15dString(string));
    }

    public JComponent appendSeparator() {
        return this.appendSeparator("");
    }

    public JComponent appendSeparator(String string) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.paragraphGapSpec);
        this.ensureHasComponentLine();
        this.setColumn(super.getLeadingColumn());
        int n = this.getColumnCount();
        this.setColumnSpan(this.getColumnCount());
        JComponent jComponent = this.addSeparator(string);
        this.setColumnSpan(1);
        this.nextColumn(n);
        return jComponent;
    }

    public void appendI15dSeparator(String string) {
        this.appendSeparator(this.getI15dString(string));
    }

    protected int getLeadingColumn() {
        int n = super.getLeadingColumn();
        return n + this.getLeadingColumnOffset() * this.getColumnIncrementSign();
    }

    private void ensureCursorColumnInGrid() {
        if (this.isLeftToRight() && this.getColumn() > this.getColumnCount() || !this.isLeftToRight() && this.getColumn() < 1) {
            this.nextLine();
        }
    }

    private void ensureHasGapRow(RowSpec rowSpec) {
        if (this.getRow() != 1 && this.getRow() > this.getRowCount()) {
            RowSpec rowSpec2;
            if (this.getRow() <= this.getRowCount() && (rowSpec2 = this.getCursorRowSpec()) == rowSpec) {
                return;
            }
            this.appendRow(rowSpec);
            this.nextLine();
        }
    }

    private void ensureHasComponentLine() {
        if (this.getRow() > this.getRowCount()) {
            this.appendRow(FormFactory.PREF_ROWSPEC);
            if (this.isRowGroupingEnabled()) {
                this.getLayout().addGroupedRow(this.getRow());
            }
        }
    }

    private RowSpec getCursorRowSpec() {
        return this.getLayout().getRowSpec(this.getRow());
    }

    public void appendWithBorder(Border border, EditCampo editCampo, int n) {
        JPanel jPanel = this.createAllPanel(editCampo);
        jPanel.setBorder(border);
        this.append((Component)jPanel, n, false);
    }

    public void appendButtonGroup(Border border, EditCampo editCampo, int n) {
        JPanel jPanel = this.createButtonGroupPanel(editCampo);
        jPanel.setBorder(border);
        this.append((Component)jPanel, n, false);
    }

    public JPanel createButtonGroupPanel(EditCampo editCampo) {
        EditCampo editCampo2 = editCampo;
        JPanel jPanel = new JPanel(new BorderLayout());
        new CellConstraints();
        jPanel.add((Component)editCampo2.getComponenteEditor(), "Center");
        jPanel.add((Component)editCampo2.getButtonMensagem(), "East");
        jPanel.setOpaque(false);
        return jPanel;
    }

    public void appendButtonGroupFormLayout(Border border, EditCampo editCampo, int n) {
        JPanel jPanel = this.createButtonGroupPanelFormLayout(editCampo);
        jPanel.setBorder(border);
        this.append((Component)jPanel, n, false);
    }

    public JPanel createButtonGroupPanelFormLayout(EditCampo editCampo) {
        EditLogico editLogico = (EditLogico)editCampo;
        JPanel jPanel = new JPanel(new FormLayout("left:pref, 2dlu, center:MAX(8dlu;M)", "fill:p,fill:p"));
        Box box = new Box(editLogico.getOrientacaoTexto());
        CellConstraints cellConstraints = new CellConstraints();
        for (JRadioButton jRadioButton : editLogico.getListaRadiosOrdenada()) {
            box.add(jRadioButton);
            if (editLogico.getOrientacaoTexto() != 0) continue;
            box.add(new JLabel(" "));
        }
        jPanel.add((Component)box, cellConstraints.xy(1, 1));
        jPanel.add((Component)editLogico.getButtonMensagem(), cellConstraints.xywh(3, 1, 1, 2));
        jPanel.setOpaque(false);
        return jPanel;
    }
}

