/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.negocio.Valor;

public class ModeloSimplificada
extends ModeloDeclaracao {
    public static final String LIMITE_DESCONTO_SIMPLIFICADO = "16.754,34";
    private Valor rendRecebidoPJTitular = new Valor(this, "");
    private Valor rendRecebidoPJDependentes = new Valor(this, "");
    private Valor rendRecebidoPFEXT_TIT = new Valor(this, "");
    private Valor rendRecebidoPFEXT_DEP = new Valor(this, "");
    private Valor resultadoTributavelAR = new Valor(this, "");
    private Valor totalResultadosTributaveis = new Valor(this, "");
    private Valor descontoSimplificado = new Valor(this, "");
    private Valor impostoRetidoFonteTitular = new Valor(this, "");
    private Valor impostoRetidoFonteDependentes = new Valor(this, "");
    private Valor carneLeao = new Valor(this, "");
    private Valor impostoComplementar = new Valor(this, "");
    private Valor impostoRetidoFonteLei11033 = new Valor(this, "");
    private Valor rendIsentosNaoTributaveis = new Valor(this, "");
    private Valor rendSujeitoTribExclusiva = new Valor(this, "");
    private Valor bensDireitosExercicioAnterior = new Valor(this, "");
    private Valor bensDireitosExercicioAtual = new Valor(this, "");
    private Valor dividasExercicioAnterior = new Valor(this, "");
    private Valor dividasExercicioAtual = new Valor(this, "");
    private Valor totalImpostoRetidoNaFonte = new Valor(this, "");

    public ModeloSimplificada(DeclaracaoIRPF declaracaoIRPF) {
        super(declaracaoIRPF);
    }

    public void resumoCalculoImposto() {
        this.rendRecebidoPJTitular.setConteudo(this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        this.rendRecebidoPJDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        this.rendRecebidoPFEXT_TIT.clear();
        this.rendRecebidoPFEXT_TIT.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPessoaFisica());
        this.rendRecebidoPFEXT_TIT.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoPFEXT_DEP.clear();
        this.rendRecebidoPFEXT_DEP.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPessoaFisica());
        this.rendRecebidoPFEXT_DEP.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.resultadoTributavelAR.clear();
        if (this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel());
        }
        if (this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel());
        }
        this.totalResultadosTributaveis.clear();
        this.totalResultadosTributaveis.append('+', this.rendRecebidoPJTitular);
        this.totalResultadosTributaveis.append('+', this.rendRecebidoPJDependentes);
        this.totalResultadosTributaveis.append('+', this.rendRecebidoPFEXT_TIT);
        this.totalResultadosTributaveis.append('+', this.rendRecebidoPFEXT_DEP);
        this.totalResultadosTributaveis.append('+', this.resultadoTributavelAR);
        Valor valor = new Valor();
        valor.setConteudo(this.totalResultadosTributaveis.operacao('*', "0,20"));
        if (valor.comparacao(">", LIMITE_DESCONTO_SIMPLIFICADO)) {
            valor.setConteudo(LIMITE_DESCONTO_SIMPLIFICADO);
        }
        this.descontoSimplificado.setConteudo(valor);
        this.baseCalculo.clear();
        this.baseCalculo.append('+', this.totalResultadosTributaveis);
        this.baseCalculo.append('-', this.descontoSimplificado);
        this.impostoDevido.setConteudo(this.calculaImposto(this.baseCalculo));
        this.impostoRetidoFonteTitular.setConteudo(this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisImpostoRetidoFonte());
        this.impostoRetidoFonteDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisImpostoRetidoFonte());
        this.carneLeao.clear();
        this.carneLeao.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalDarfPago());
        this.carneLeao.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalDarfPago());
        this.impostoComplementar.clear();
        this.impostoComplementar.append('+', this.declaracaoIRPF.getImpostoPago().getImpostoComplementar());
        this.impostoRetidoFonteLei11033.setConteudo(this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte());
        this.saldoImpostoPagar.clear();
        this.impostoRestituir.clear();
        Valor valor2 = new Valor();
        valor2.append('+', this.impostoRetidoFonteTitular);
        valor2.append('+', this.impostoRetidoFonteDependentes);
        valor2.append('+', this.carneLeao);
        valor2.append('+', this.impostoComplementar);
        valor2.append('+', this.impostoRetidoFonteLei11033);
        if (this.impostoDevido.comparacao("<", valor2)) {
            this.impostoRestituir.setConteudo(valor2.operacao('-', this.impostoDevido));
        } else {
            this.saldoImpostoPagar.setConteudo(this.impostoDevido.operacao('-', valor2));
        }
    }

    public void resumoOutrasInformacoes() {
        this.rendIsentosNaoTributaveis.setConteudo(this.declaracaoIRPF.getRendIsentos().getTotal());
        this.rendSujeitoTribExclusiva.setConteudo(this.declaracaoIRPF.getRendTributacaoExclusiva().getTotal());
        this.bensDireitosExercicioAnterior.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAnterior());
        this.bensDireitosExercicioAtual.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAtual());
        this.dividasExercicioAnterior.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAnterior());
        this.dividasExercicioAtual.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAtual());
        this.totalImpostoRetidoNaFonte.clear();
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        this.totalDoacoesCampanhasEleitorais.setConteudo(this.declaracaoIRPF.getDoacoes().getTotalDoacoes());
    }

    public void resumoRendimentosTributaveis() {
    }

    public void aplicaValoresNaDeclaracao() {
        this.declaracaoIRPF.getResumo().getCalculoImposto().getRendPJRecebidoTitular().setConteudo(this.rendRecebidoPJTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getRendPJRecebidoDependentes().setConteudo(this.rendRecebidoPJDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getRendPFEXTRecebidoTitular().setConteudo(this.rendRecebidoPFEXT_TIT);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getRendPFEXTRecebidoDependentes().setConteudo(this.rendRecebidoPFEXT_DEP);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getResultadoTributavelAR().setConteudo(this.resultadoTributavelAR);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalResultadosTributaveis().setConteudo(this.totalResultadosTributaveis);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getDescontoSimplificado().setConteudo(this.descontoSimplificado);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getBaseCalculo().setConteudo(this.baseCalculo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevido().setConteudo(this.impostoDevido);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().setConteudo(this.impostoRetidoFonteTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().setConteudo(this.impostoRetidoFonteDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeao().setConteudo(this.carneLeao);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().setConteudo(this.impostoComplementar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().setConteudo(this.impostoRetidoFonteLei11033);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar().setConteudo(this.saldoImpostoPagar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir().setConteudo(this.impostoRestituir);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis().setConteudo(this.rendIsentosNaoTributaveis);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva().setConteudo(this.rendSujeitoTribExclusiva);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAnterior().setConteudo(this.bensDireitosExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAtual().setConteudo(this.bensDireitosExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAnterior().setConteudo(this.dividasExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAtual().setConteudo(this.dividasExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalImpostoRetidoNaFonte().setConteudo(this.totalImpostoRetidoNaFonte);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais().setConteudo(this.totalDoacoesCampanhasEleitorais);
    }

    public Valor getBensDireitosExercicioAnterior() {
        return this.bensDireitosExercicioAnterior;
    }

    public Valor getBensDireitosExercicioAtual() {
        return this.bensDireitosExercicioAtual;
    }

    public Valor getDescontoSimplificado() {
        return this.descontoSimplificado;
    }

    public Valor getDividasExercicioAnterior() {
        return this.dividasExercicioAnterior;
    }

    public Valor getDividasExercicioAtual() {
        return this.dividasExercicioAtual;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getImpostoDevidoII() {
        return this.impostoDevidoII;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Valor getRendIsentosNaoTributaveis() {
        return this.rendIsentosNaoTributaveis;
    }

    public Valor getRendRecebidoPJDependentes() {
        return this.rendRecebidoPJDependentes;
    }

    public Valor getRendRecebidoPJTitular() {
        return this.rendRecebidoPJTitular;
    }

    public Valor getRendRecebidoPFEXTDependentes() {
        return this.rendRecebidoPFEXT_DEP;
    }

    public Valor getRendRecebidoPFEXTTitular() {
        return this.rendRecebidoPFEXT_TIT;
    }

    public Valor getRendSujeitoTribExclusiva() {
        return this.rendSujeitoTribExclusiva;
    }

    public Valor getResultadoTributavelAR() {
        return this.resultadoTributavelAR;
    }

    public Valor getTotalResultadosTributaveis() {
        return this.totalResultadosTributaveis;
    }

    public Valor recuperarTotalImpostoPago() {
        Valor valor = new Valor();
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeao());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033());
        return valor;
    }

    public String recuperarCodInImpostoPago() {
        int n = 0;
        String string = "";
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().isVazio() || !this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().isVazio()) {
            ++n;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoMaisImpostoComplementar().isVazio()) {
            n += 6;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().isVazio()) {
            n += 16;
        }
        string = n < 9 ? "0" + n : "" + n;
        return string;
    }

    public Valor calculaImpostoLei11033ComRendaVariavel() {
        return this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte().operacao('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
    }

    public Valor recuperarTotalRendimentosTributaveis() {
        Valor valor = new Valor(this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalResultadosTributaveis().getConteudoFormatado());
        return valor;
    }

    public Valor getCarneLeao() {
        return this.carneLeao;
    }

    public Valor getImpostoComplementar() {
        return this.impostoComplementar;
    }
}

