/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.editors.PPGDCheckBox;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.OpcaoDefault;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ItemOpcao;
import serpro.ppgd.negocio.Opcao;
import serpro.ppgd.negocio.util.LogPPGD;

public class JEditOpcao
extends JEditCampo {
    private Box box;
    private int orientacaoTexto;
    private static final Color DEFAULT_FOREGROUND = new JCheckBox().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map opcoes;
    private LinkedList listaOrdenada = new LinkedList();

    public JEditOpcao() {
        this(new OpcaoDefault());
    }

    public JEditOpcao(Informacao informacao) {
        super(informacao);
        this.setOrientacaoTexto(1);
    }

    public void setFont(Font font) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setFont(font);
        }
    }

    public void setForeground(Color color) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setForeground(color);
        }
    }

    public void setFont(String string, Color color) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            jCheckBox.setForeground(color);
        }
    }

    public void setFont(String string, Font font) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            jCheckBox.setFont(font);
        }
    }

    public void addListener(String string, EventListener eventListener) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            this.adicionaListener(jCheckBox, eventListener);
        }
    }

    private void adicionaListener(JCheckBox jCheckBox, EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            jCheckBox.addActionListener((ActionListener)eventListener);
        } else if (eventListener instanceof ItemListener) {
            jCheckBox.addItemListener((ItemListener)eventListener);
        } else if (eventListener instanceof KeyListener) {
            jCheckBox.addKeyListener((KeyListener)eventListener);
        } else if (eventListener instanceof FocusListener) {
            jCheckBox.addFocusListener((FocusListener)eventListener);
        } else if (eventListener instanceof MouseListener) {
            jCheckBox.addMouseListener((MouseListener)eventListener);
        } else if (eventListener instanceof MouseMotionListener) {
            jCheckBox.addMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public void addListener(EventListener eventListener) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            this.adicionaListener(jCheckBox, eventListener);
        }
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int n) {
        this.orientacaoTexto = n;
        this.buildComponente();
    }

    public void setOpcaoHabilitada(String string, boolean bl) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            jCheckBox.setEnabled(bl);
            if (!bl) {
                jCheckBox.setForeground(DISABLED_FOREGROUND);
            } else {
                jCheckBox.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setObservadorAtivo(false);
        if (propertyChangeEvent == null) {
            LogPPGD.debug("Evento nulo no metodo implementacaoPropertyChange da classe " + this.getClass());
        }
        if ((propertyChangeEvent.getPropertyName() == null || !propertyChangeEvent.getPropertyName().equals("ReadOnly")) && propertyChangeEvent.getNewValue() instanceof String) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (string == null) {
                string = "";
            }
            String string2 = ((Opcao)this.getInformacao()).getDescricaoOpcoes();
            for (JCheckBox jCheckBox : this.opcoes.values()) {
                if (string2.indexOf(jCheckBox.getText().trim()) > -1) {
                    this.setBloqueiaItemListener(true);
                    jCheckBox.setSelected(true);
                    this.setBloqueiaItemListener(false);
                    continue;
                }
                this.setBloqueiaItemListener(true);
                jCheckBox.setSelected(false);
                this.setBloqueiaItemListener(false);
            }
        }
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean bl) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setEnabled(!bl);
        }
    }

    protected void habilitadoPropertyChange(boolean bl) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setEnabled(bl);
            jCheckBox.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
        }
    }

    public JComponent getComponenteFoco() {
        if (this.opcoes.values().size() > 0) {
            return (JCheckBox)this.opcoes.values().toArray()[0];
        }
        return null;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map map) {
        this.opcoes = map;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bl) {
        this.bloqueiaItemListener = bl;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.opcoes = new Hashtable();
        this.listaOrdenada = new LinkedList();
        this.box = this.getOrientacaoTexto() == 0 ? Box.createHorizontalBox() : Box.createVerticalBox();
        Opcao opcao = (Opcao)this.getInformacao();
        if (opcao != null) {
            Object object2;
            for (Object object2 : opcao.getListaOrdenada()) {
                PPGDCheckBox pPGDCheckBox = new PPGDCheckBox(((ItemOpcao)object2).getCodigo(), ((ItemOpcao)object2).getDescricao(), ((ItemOpcao)object2).isSelecionado());
                pPGDCheckBox.setInformacao(this.campo);
                pPGDCheckBox.setVisible(true);
                pPGDCheckBox.setSelected(((ItemOpcao)object2).isSelecionado());
                this.opcoes.put(pPGDCheckBox.getName(), pPGDCheckBox);
                this.listaOrdenada.addLast(pPGDCheckBox);
                pPGDCheckBox.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        if (focusEvent.getOppositeComponent() != null) {
                            JEditOpcao.this.setIdentificacaoFoco(false);
                            JEditOpcao.this.chamaValidacao();
                        }
                    }
                });
                pPGDCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                        String string = jCheckBox.getName().trim();
                        ((Opcao)JEditOpcao.this.getInformacao()).atualizaListaValidadoresImpeditivos(string);
                        if (JEditOpcao.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || JEditOpcao.this.verificaValidacoesImpeditivas(string)) {
                            if (itemEvent.getStateChange() == 1 && !JEditOpcao.this.isBloqueiaItemListener()) {
                                ((Opcao)JEditOpcao.this.getInformacao()).addSelectedItem(string);
                            }
                            if (itemEvent.getStateChange() == 2 && !JEditOpcao.this.isBloqueiaItemListener()) {
                                ((Opcao)JEditOpcao.this.getInformacao()).delSelectedItem(string);
                            }
                        }
                    }
                });
                if (this.getOrientacaoTexto() == 0) {
                    this.box.add(new JLabel(" "));
                }
                this.box.add(pPGDCheckBox);
            }
            this.setObservadorAtivo(false);
            object2 = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
            this.implementacaoPropertyChange((PropertyChangeEvent)object2);
            this.setObservadorAtivo(true);
        }
        this.add((Component)this.box, "Center");
        JButtonMensagem jButtonMensagem = this.getButtonMensagem();
        if (jButtonMensagem != null) {
            this.add((Component)new PainelBotao(jButtonMensagem), "East");
        }
    }

    protected void informacaoModificada() {
        this.buildComponente();
    }

    public void setEstiloFonte(int n) {
        JCheckBox jCheckBox = null;
        jCheckBox = !this.opcoes.isEmpty() ? (JCheckBox)this.opcoes.values().toArray()[0] : new JCheckBox();
        Font font = jCheckBox.getFont();
        font = font.deriveFont(n);
        this.setFont(font);
    }

    public void setIncrementoTamanhoFonte(int n) {
        this.incrementoTamanhoFonte = n;
        JCheckBox jCheckBox = null;
        jCheckBox = !this.opcoes.isEmpty() ? (JCheckBox)this.opcoes.values().toArray()[0] : new JCheckBox();
        Font font = jCheckBox.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = font.getSize2D();
        }
        font = font.deriveFont(this.tamanhoOriginal + (float)n);
        this.setFont(font);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

