/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao {
    public static final String VALOR_PAGO_ALTO = "50.000,00";
    private transient DeclaracaoIRPF objDecl;
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private Valor totalDeducoesInstrucao = new Valor(this, "");
    private Valor totalContribuicaoFAPI = new Valor(this, "");
    private Valor totalDespesasMedicas = new Valor(this, "");
    private Valor totalPensao = new Valor(this, "");
    private Valor totalPensaoCartoral = new Valor(this, "");
    private Valor totalDeducaoIncentivo = new Valor(this, "");
    private Valor totalContribEmpregadoDomestico = new Valor(this, "");

    public Pagamentos(DeclaracaoIRPF declaracaoIRPF) {
        super(Pagamento.class.getName());
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.objDecl = declaracaoIRPF;
        this.setFicha("Pagamentos e Doa\u00e7\u00f5es Efetuados");
    }

    public void objetoInserido(Object object) {
        ((ObjetoNegocio)object).setFicha(this.getFicha());
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        return new Pagamento(this.objDecl);
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoFAPI() {
        return this.totalContribuicaoFAPI;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("30") && !pagamento.getCodigo().asString().equals("31")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    private Pagamento[] OrdenarPagamentosDedutiveis(int n) {
        Pagamento[] pagamentoArray = new Pagamento[n];
        block0: for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.getCodigo().toString().equals("01") && !pagamento.getCodigo().toString().equals("02") && !pagamento.getCodigo().toString().equals("09") && !pagamento.getCodigo().toString().equals("10") && !pagamento.getCodigo().toString().equals("11") && !pagamento.getCodigo().toString().equals("12") && !pagamento.getCodigo().toString().equals("13") && !pagamento.getCodigo().toString().equals("14") && !pagamento.getCodigo().toString().equals("21") && !pagamento.getCodigo().toString().equals("26") && (!pagamento.getCodigo().asString().equals("50") || pagamento.getNiBeneficiario().asString().trim().length() < 11) && !pagamento.getCodigo().asString().equals("36") && !pagamento.getCodigo().asString().equals("38")) continue;
            int n2 = 0;
            while (n2 < n) {
                if (pagamentoArray[n2] == null || pagamento.getValorPago().comparacao(">", pagamentoArray[n2].getValorPago())) {
                    while (n2 < n) {
                        Pagamento pagamento2 = pagamentoArray[n2];
                        pagamentoArray[n2] = pagamento;
                        pagamento = pagamento2;
                        ++n2;
                    }
                    continue block0;
                }
                ++n2;
            }
        }
        return pagamentoArray;
    }

    public String[] recuperarNiMaioresPagamentosDedutiveis(int n) {
        String[] stringArray = new String[n];
        Pagamento[] pagamentoArray = this.OrdenarPagamentosDedutiveis(n);
        int n2 = 0;
        while (n2 < n) {
            if (pagamentoArray[n2] == null) break;
            stringArray[n2] = pagamentoArray[n2].getNiBeneficiario().asString();
            ++n2;
        }
        return stringArray;
    }

    public String recuperarCnpjMaiorPagamentoFunpresp() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("37")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString();
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString();
        }
        return string;
    }

    private Pagamento OrdenarEmpregadosDomesticos(int n) {
        Pagamento[] pagamentoArray = new Pagamento[n];
        block0: for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.getCodigo().asString().equals("50") || pagamento.getNiBeneficiario().asString().trim().length() < 11) continue;
            int n2 = 0;
            while (n2 < n) {
                if (pagamentoArray[n2] == null || pagamento.getValorPago().comparacao(">", pagamentoArray[n2].getValorPago())) {
                    while (n2 < n) {
                        Pagamento pagamento2 = pagamentoArray[n2];
                        pagamentoArray[n2] = pagamento;
                        pagamento = pagamento2;
                        ++n2;
                    }
                    continue block0;
                }
                ++n2;
            }
        }
        return pagamentoArray[n - 1];
    }

    private static String CpfEmpregadoDomestico(Pagamento pagamento) {
        if (pagamento == null) {
            return "";
        }
        return pagamento.getNiBeneficiario().asString().substring(0, 11);
    }

    private static String NitEmpregadoDomestico(Pagamento pagamento) {
        if (pagamento == null) {
            return "";
        }
        return pagamento.getNitEmpregadoDomestico().asString();
    }

    public String recuperarCpfMaiorEmpregadaDomestica() {
        return Pagamentos.CpfEmpregadoDomestico(this.OrdenarEmpregadosDomesticos(1));
    }

    public String recuperarNitMaiorEmpregadaDomestica() {
        return Pagamentos.NitEmpregadoDomestico(this.OrdenarEmpregadosDomesticos(1));
    }

    public String recuperarCpfEmpregadaDomesticaDois() {
        return Pagamentos.CpfEmpregadoDomestico(this.OrdenarEmpregadosDomesticos(2));
    }

    public String recuperarNitEmpregadaDomesticaDois() {
        return Pagamentos.NitEmpregadoDomestico(this.OrdenarEmpregadosDomesticos(2));
    }

    public String recuperarCpfEmpregadaDomesticaTres() {
        return Pagamentos.CpfEmpregadoDomestico(this.OrdenarEmpregadosDomesticos(3));
    }

    public String recuperarNitEmpregadaDomesticaTres() {
        return Pagamentos.NitEmpregadoDomestico(this.OrdenarEmpregadosDomesticos(3));
    }

    public String recuperarCNPJMaiorPrevComplementar() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("36") && !pagamento.getCodigo().asString().equals("38")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public String recuperarCNPJSegundaMaiorPrevComplementar() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        Valor valor2 = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("36") && !pagamento.getCodigo().asString().equals("38")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (pagamento.getValorPago().comparacao(">", valor)) {
                valor2 = valor;
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (valor2 == null) {
                valor2 = pagamento.getValorPago();
                pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor2)) continue;
            valor2 = pagamento.getValorPago();
            pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public NI recuperarNIMaiorDespMedicas() {
        Object object;
        Object object2;
        class BeneficiarioMedico {
            public Valor total;
            public NI ni;

            BeneficiarioMedico() {
            }
        }
        Hashtable<String, BeneficiarioMedico> hashtable = new Hashtable<String, BeneficiarioMedico>();
        List list = this.recuperarLista();
        int n = 0;
        while (n < this.recuperarLista().size()) {
            object2 = (Pagamento)list.get(n);
            if (((Pagamento)object2).getCodigo().toString().equals("09") || ((Pagamento)object2).getCodigo().toString().equals("10") || ((Pagamento)object2).getCodigo().toString().equals("11") || ((Pagamento)object2).getCodigo().toString().equals("12") || ((Pagamento)object2).getCodigo().toString().equals("13") || ((Pagamento)object2).getCodigo().toString().equals("14") || ((Pagamento)object2).getCodigo().toString().equals("21") || ((Pagamento)object2).getCodigo().toString().equals("26")) {
                object = new Valor();
                if (((Pagamento)object2).getValorPago().comparacao(">=", ((Pagamento)object2).getParcelaNaoDedutivel())) {
                    ((Valor)object).append('+', ((Pagamento)object2).getValorPago());
                    ((Valor)object).append('-', ((Pagamento)object2).getParcelaNaoDedutivel());
                }
                String string = ((Pagamento)object2).getDependenteOuAlimentando().asString();
                String string2 = String.valueOf(((Pagamento)object2).getNiBeneficiario().asString()) + string;
                BeneficiarioMedico beneficiarioMedico = (BeneficiarioMedico)hashtable.get(string2);
                if (beneficiarioMedico == null) {
                    beneficiarioMedico = new BeneficiarioMedico();
                    beneficiarioMedico.total = object;
                    beneficiarioMedico.ni = ((Pagamento)object2).getNiBeneficiario();
                    hashtable.put(string2, beneficiarioMedico);
                } else {
                    beneficiarioMedico.total.append('+', (Valor)object);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.values().iterator();
        object2 = null;
        if (iterator.hasNext()) {
            object2 = (BeneficiarioMedico)iterator.next();
            while (iterator.hasNext()) {
                object = (BeneficiarioMedico)iterator.next();
                if (!((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object2).total)) continue;
                object2 = object;
            }
        }
        if (object2 == null) {
            return new NI(this, "");
        }
        return ((BeneficiarioMedico)object2).ni;
    }

    public NI recuperarNISegundoMaiorDespMedicas() {
        Object object;
        Object object2;
        Object object3;
        class BeneficiarioMedico {
            public Valor total;
            public NI ni;

            BeneficiarioMedico() {
            }
        }
        Hashtable<String, BeneficiarioMedico> hashtable = new Hashtable<String, BeneficiarioMedico>();
        List list = this.recuperarLista();
        int n = 0;
        while (n < this.recuperarLista().size()) {
            object3 = (Pagamento)list.get(n);
            if (((Pagamento)object3).getCodigo().toString().equals("09") || ((Pagamento)object3).getCodigo().toString().equals("10") || ((Pagamento)object3).getCodigo().toString().equals("11") || ((Pagamento)object3).getCodigo().toString().equals("12") || ((Pagamento)object3).getCodigo().toString().equals("13") || ((Pagamento)object3).getCodigo().toString().equals("14") || ((Pagamento)object3).getCodigo().toString().equals("21") || ((Pagamento)object3).getCodigo().toString().equals("26")) {
                object2 = new Valor();
                if (((Pagamento)object3).getValorPago().comparacao(">=", ((Pagamento)object3).getParcelaNaoDedutivel())) {
                    ((Valor)object2).append('+', ((Pagamento)object3).getValorPago());
                    ((Valor)object2).append('-', ((Pagamento)object3).getParcelaNaoDedutivel());
                }
                object = ((Pagamento)object3).getDependenteOuAlimentando().asString();
                String string = String.valueOf(((Pagamento)object3).getNiBeneficiario().asString()) + (String)object;
                BeneficiarioMedico beneficiarioMedico = (BeneficiarioMedico)hashtable.get(string);
                if (beneficiarioMedico == null) {
                    beneficiarioMedico = new BeneficiarioMedico();
                    beneficiarioMedico.total = object2;
                    beneficiarioMedico.ni = ((Pagamento)object3).getNiBeneficiario();
                    hashtable.put(string, beneficiarioMedico);
                } else {
                    beneficiarioMedico.total.append('+', (Valor)object2);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.values().iterator();
        object3 = null;
        object2 = null;
        if (iterator.hasNext()) {
            object3 = (BeneficiarioMedico)iterator.next();
            while (iterator.hasNext()) {
                object = (BeneficiarioMedico)iterator.next();
                if (((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object3).total)) {
                    object2 = object3;
                    object3 = object;
                    continue;
                }
                if (object2 != null && !((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object2).total)) continue;
                object2 = object;
            }
        }
        if (object2 == null) {
            return new NI(this, "");
        }
        return ((BeneficiarioMedico)object2).ni;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n = 0;
        if (!hashSet.isEmpty()) {
            n = hashSet.size();
        }
        return n;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n = 0;
        if (!hashSet.isEmpty()) {
            n = hashSet.size();
        }
        return n;
    }

    public void setTotalContribEmpregadoDomestico(Valor valor) {
        this.totalContribEmpregadoDomestico = valor;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }
}

