package serpro.ppgd.irpf;
import java.util.Iterator;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroOutrosRendimentos extends Colecao
{
  private transient DeclaracaoIRPF objDecl;
  private Valor totais;

  public ColecaoItemQuadroOutrosRendimentos (final DeclaracaoIRPF objDecl,
					     final String ficha)
  {
    super (serpro.ppgd.irpf.ItemQuadroOutrosRendimentos.class.getName ());
    totais = new Valor (this, "Totais");
    getTotais ().setReadOnly (true);
    this.objDecl = objDecl;
    setFicha (ficha);
  }

  public ObjetoNegocio instanciaNovoObjeto ()
  {
    return new ItemQuadroOutrosRendimentos (objDecl);
  }

  public Valor getTotais ()
  {
    return totais;
  }

  public void objetoInserido (Object o)
  {
    ((ObjetoNegocio) o).setFicha (getFicha ());

    ((ItemQuadroOutrosRendimentos) o).getValor ().addObservador (this);
    calculaTotal ();
  }

  public void objetoRemovido (Object o)
  {
    ((ItemQuadroOutrosRendimentos) o).getValor ().removeObservador (this);
    calculaTotal ();
  }

  private void calculaTotal ()
  {
    Iterator it = recuperarLista ().iterator ();
    totais.clear ();
    while (it.hasNext ())
      {
	ItemQuadroOutrosRendimentos itemQuadroAuxiliar
	  = (ItemQuadroOutrosRendimentos) it.next ();
	totais.append ('+', itemQuadroAuxiliar.getValor ());
      }
  }

  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    calculaTotal ();
  }
}
