/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRException;

public class BucketingService {
    protected static final byte DIMENSION_ROW = 0;
    protected static final byte DIMENSION_COLUMN = 1;
    protected static final int DIMENSIONS = 2;
    protected final BucketDefinition[] allBuckets;
    protected final BucketDefinition[][] buckets;
    protected final int rowBucketCount;
    protected final int colBucketCount;
    protected final boolean[][] retrieveTotal;
    private boolean[] rowRetrTotals;
    private int rowRetrTotalMin;
    private int rowRetrTotalMax;
    private int[] rowRetrColMax;
    protected final MeasureDefinition[] measures;
    protected final int origMeasureCount;
    protected final int[] measureIndexes;
    protected final boolean sorted;
    protected final BucketMap bucketValueMap;
    protected long dataCount;
    protected boolean processed;
    protected HeaderCell[][] colHeaders;
    protected HeaderCell[][] rowHeaders;
    protected CrosstabCell[][] cells;
    private final MeasureDefinition.MeasureValue[] zeroUserMeasureValues;

    public BucketingService(List list, List list2, List list3, boolean bl, boolean[][] blArray) {
        this.sorted = bl;
        this.buckets = new BucketDefinition[2][];
        this.rowBucketCount = list.size();
        this.buckets[0] = new BucketDefinition[this.rowBucketCount];
        list.toArray(this.buckets[0]);
        this.colBucketCount = list2.size();
        this.buckets[1] = new BucketDefinition[this.colBucketCount];
        list2.toArray(this.buckets[1]);
        this.allBuckets = new BucketDefinition[this.rowBucketCount + this.colBucketCount];
        System.arraycopy(this.buckets[0], 0, this.allBuckets, 0, this.rowBucketCount);
        System.arraycopy(this.buckets[1], 0, this.allBuckets, this.rowBucketCount, this.colBucketCount);
        this.origMeasureCount = list3.size();
        ArrayList arrayList = new ArrayList(list3.size() * 2);
        ArrayList arrayList2 = new ArrayList(list3.size() * 2);
        int n = 0;
        while (n < list3.size()) {
            MeasureDefinition measureDefinition = (MeasureDefinition)list3.get(n);
            this.addMeasure(measureDefinition, n, arrayList, arrayList2);
            ++n;
        }
        this.measures = new MeasureDefinition[arrayList.size()];
        arrayList.toArray(this.measures);
        this.measureIndexes = new int[arrayList2.size()];
        n = 0;
        while (n < this.measureIndexes.length) {
            this.measureIndexes[n] = (Integer)arrayList2.get(n);
            ++n;
        }
        this.retrieveTotal = blArray;
        this.checkTotals();
        this.bucketValueMap = this.createBucketMap(0);
        this.zeroUserMeasureValues = this.initUserMeasureValues();
    }

    protected void checkTotals() {
        int n;
        this.rowRetrTotalMin = this.rowBucketCount + 1;
        this.rowRetrTotalMax = -1;
        this.rowRetrTotals = new boolean[this.rowBucketCount + 1];
        this.rowRetrColMax = new int[this.rowBucketCount + 1];
        int n2 = 0;
        while (n2 <= this.rowBucketCount) {
            this.rowRetrColMax[n2] = -1;
            boolean bl = false;
            n = 0;
            while (n <= this.colBucketCount) {
                if (this.retrieveTotal[n2][n]) {
                    bl = true;
                    this.rowRetrColMax[n2] = n;
                }
                ++n;
            }
            this.rowRetrTotals[n2] = bl;
            if (bl) {
                if (n2 < this.rowRetrTotalMin) {
                    this.rowRetrTotalMin = n2;
                }
                this.rowRetrTotalMax = n2;
                if (n2 < this.rowBucketCount) {
                    this.allBuckets[n2].setComputeTotal();
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.colBucketCount) {
            BucketDefinition bucketDefinition = this.allBuckets[this.rowBucketCount + n2];
            if (!bucketDefinition.computeTotal()) {
                n = 0;
                int n3 = 0;
                while (n == 0 && n3 <= this.rowBucketCount) {
                    n = this.retrieveTotal[n3][n2];
                    ++n3;
                }
                if (n != 0) {
                    bucketDefinition.setComputeTotal();
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 2) {
            boolean bl = false;
            n = 0;
            while (n < this.buckets[n2].length) {
                if (bl) {
                    this.buckets[n2][n].setComputeTotal();
                } else {
                    bl = this.buckets[n2][n].computeTotal();
                }
                ++n;
            }
            ++n2;
        }
    }

    public void clear() {
        this.bucketValueMap.clear();
        this.processed = false;
        this.dataCount = 0L;
    }

    protected BucketMap createBucketMap(int n) {
        BucketMap bucketMap = this.sorted ? new BucketListMap(n, false) : new BucketTreeMap(n);
        return bucketMap;
    }

    protected BucketListMap createCollectBucketMap(int n) {
        return new BucketListMap(n, true);
    }

    protected void addMeasure(MeasureDefinition measureDefinition, int n, List list, List list2) {
        switch (measureDefinition.getCalculation()) {
            case 3: 
            case 7: {
                MeasureDefinition measureDefinition2 = MeasureDefinition.createHelperMeasure(measureDefinition, (byte)2);
                this.addMeasure(measureDefinition2, n, list, list2);
                MeasureDefinition measureDefinition3 = MeasureDefinition.createHelperMeasure(measureDefinition, (byte)1);
                this.addMeasure(measureDefinition3, n, list, list2);
                break;
            }
            case 6: {
                MeasureDefinition measureDefinition4 = MeasureDefinition.createHelperMeasure(measureDefinition, (byte)7);
                this.addMeasure(measureDefinition4, n, list, list2);
                break;
            }
            case 10: {
                MeasureDefinition measureDefinition5 = MeasureDefinition.createDistinctCountHelperMeasure(measureDefinition);
                this.addMeasure(measureDefinition5, n, list, list2);
            }
        }
        list.add(measureDefinition);
        list2.add(new Integer(n));
    }

    public void addData(Object[] objectArray, Object[] objectArray2) throws JRException {
        if (this.processed) {
            throw new JRException("Crosstab data has already been processed.");
        }
        ++this.dataCount;
        BucketDefinition.Bucket[] bucketArray = this.getBucketValues(objectArray);
        MeasureDefinition.MeasureValue[] measureValueArray = this.bucketValueMap.insertMeasureValues(bucketArray);
        int n = 0;
        while (n < this.measures.length) {
            measureValueArray[n].addValue(objectArray2[this.measureIndexes[n]]);
            ++n;
        }
    }

    protected BucketDefinition.Bucket[] getBucketValues(Object[] objectArray) {
        BucketDefinition.Bucket[] bucketArray = new BucketDefinition.Bucket[this.allBuckets.length];
        int n = 0;
        while (n < this.allBuckets.length) {
            BucketDefinition bucketDefinition = this.allBuckets[n];
            Object object = objectArray[n];
            bucketArray[n] = bucketDefinition.create(object);
            ++n;
        }
        return bucketArray;
    }

    protected MeasureDefinition.MeasureValue[] initMeasureValues() {
        MeasureDefinition.MeasureValue[] measureValueArray = new MeasureDefinition.MeasureValue[this.measures.length];
        int n = 0;
        while (n < this.measures.length) {
            MeasureDefinition measureDefinition = this.measures[n];
            measureValueArray[n] = new MeasureDefinition.MeasureValue(measureDefinition);
            switch (measureDefinition.getCalculation()) {
                case 3: 
                case 7: {
                    measureValueArray[n].setHelper(measureValueArray[n - 2], (byte)1);
                    measureValueArray[n].setHelper(measureValueArray[n - 1], (byte)0);
                    break;
                }
                case 6: {
                    measureValueArray[n].setHelper(measureValueArray[n - 1], (byte)2);
                }
                case 10: {
                    measureValueArray[n].setHelper(measureValueArray[n - 1], (byte)0);
                }
            }
            ++n;
        }
        return measureValueArray;
    }

    protected MeasureDefinition.MeasureValue[] initUserMeasureValues() {
        MeasureDefinition.MeasureValue[] measureValueArray = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.measures.length) {
            if (!this.measures[n2].isSystemDefined()) {
                measureValueArray[n] = new MeasureDefinition.MeasureValue(this.measures[n2]);
                ++n;
            }
            ++n2;
        }
        return measureValueArray;
    }

    public void processData() throws JRException {
        if (!this.processed) {
            if (this.dataCount > 0L) {
                if (this.allBuckets[this.rowBucketCount - 1].computeTotal() || this.allBuckets[this.allBuckets.length - 1].computeTotal()) {
                    this.computeTotals(this.bucketValueMap);
                }
                this.createCrosstab();
            }
            this.processed = true;
        }
    }

    public boolean hasData() {
        return this.dataCount > 0L;
    }

    public HeaderCell[][] getColumnHeaders() {
        return this.colHeaders;
    }

    public HeaderCell[][] getRowHeaders() {
        return this.rowHeaders;
    }

    public CrosstabCell[][] getCrosstabCells() {
        return this.cells;
    }

    public MeasureDefinition.MeasureValue[] getMeasureValues(BucketDefinition.Bucket[] bucketArray) {
        BucketMap bucketMap = this.bucketValueMap;
        int n = 0;
        while (bucketMap != null && n < this.allBuckets.length - 1) {
            bucketMap = (BucketMap)bucketMap.get(bucketArray[n]);
            ++n;
        }
        return bucketMap == null ? null : (MeasureDefinition.MeasureValue[])bucketMap.get(bucketArray[this.allBuckets.length - 1]);
    }

    protected MeasureDefinition.MeasureValue[] getUserMeasureValues(MeasureDefinition.MeasureValue[] measureValueArray) {
        MeasureDefinition.MeasureValue[] measureValueArray2 = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.measures.length) {
            if (!this.measures[n2].isSystemDefined()) {
                measureValueArray2[n] = measureValueArray[n2];
                ++n;
            }
            ++n2;
        }
        return measureValueArray2;
    }

    public MeasureDefinition.MeasureValue[] getGrandTotals() {
        BucketMap bucketMap = this.bucketValueMap;
        int n = 0;
        while (bucketMap != null && n < this.allBuckets.length - 1) {
            bucketMap = (BucketMap)bucketMap.getTotalEntry().getValue();
            ++n;
        }
        return bucketMap == null ? null : (MeasureDefinition.MeasureValue[])bucketMap.getTotalEntry().getValue();
    }

    protected void computeTotals(BucketMap bucketMap) throws JRException {
        boolean bl;
        boolean bl2 = bl = bucketMap.level >= this.rowBucketCount;
        if (bl && !this.allBuckets[this.allBuckets.length - 1].computeTotal()) {
            return;
        }
        if (!bucketMap.last) {
            Iterator iterator = bucketMap.entryIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.computeTotals((BucketMap)entry.getValue());
            }
        }
        if (this.allBuckets[bucketMap.level].computeTotal()) {
            if (bl) {
                this.computeColumnTotal(bucketMap);
            } else {
                this.computeRowTotals(bucketMap);
            }
        }
    }

    protected void sumVals(MeasureDefinition.MeasureValue[] measureValueArray, MeasureDefinition.MeasureValue[] measureValueArray2) throws JRException {
        int n = 0;
        while (n < this.measures.length) {
            measureValueArray[n].addValue(measureValueArray2[n]);
            ++n;
        }
    }

    protected void computeColumnTotal(BucketMap bucketMap) throws JRException {
        MeasureDefinition.MeasureValue[] measureValueArray = this.initMeasureValues();
        Iterator iterator = bucketMap.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            int n = bucketMap.level + 1;
            while (n < this.allBuckets.length) {
                entry = ((BucketMap)entry.getValue()).getTotalEntry();
                ++n;
            }
            this.sumVals(measureValueArray, (MeasureDefinition.MeasureValue[])entry.getValue());
        }
        int n = bucketMap.level + 1;
        while (n < this.allBuckets.length) {
            bucketMap = bucketMap.addTotalNextMap();
            ++n;
        }
        bucketMap.addTotalEntry(measureValueArray);
    }

    protected void computeRowTotals(BucketMap bucketMap) throws JRException {
        BucketListMap bucketListMap = this.createCollectBucketMap(this.rowBucketCount);
        Object object = bucketMap.entryIterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            int n = bucketMap.level + 1;
            while (n < this.rowBucketCount) {
                entry = ((BucketMap)entry.getValue()).getTotalEntry();
                ++n;
            }
            bucketListMap.collectVals((BucketMap)entry.getValue(), true);
        }
        object = bucketMap;
        int n = bucketMap.level + 1;
        while (n < this.rowBucketCount) {
            object = ((BucketMap)object).addTotalNextMap();
            ++n;
        }
        ((BucketMap)object).addTotalEntry(bucketListMap);
    }

    protected void createCrosstab() throws JRException {
        BucketListMap bucketListMap;
        CollectedList[] collectedListArray = new CollectedList[2];
        collectedListArray[0] = this.createHeadersList((byte)0, this.bucketValueMap, 0, false);
        if (this.allBuckets[0].computeTotal()) {
            BucketMap bucketMap = this.bucketValueMap;
            int n = 0;
            while (n < this.rowBucketCount) {
                bucketMap = (BucketMap)bucketMap.getTotalEntry().getValue();
                ++n;
            }
            bucketListMap = (BucketListMap)bucketMap;
        } else {
            bucketListMap = this.createCollectBucketMap(this.rowBucketCount);
            this.collectCols(bucketListMap, this.bucketValueMap);
        }
        collectedListArray[1] = this.createHeadersList((byte)1, bucketListMap, 0, false);
        this.colHeaders = this.createHeaders((byte)1, collectedListArray);
        this.rowHeaders = this.createHeaders((byte)0, collectedListArray);
        this.cells = new CrosstabCell[collectedListArray[0].span][collectedListArray[1].span];
        this.fillCells(collectedListArray, this.bucketValueMap, 0, new int[2], new ArrayList(), new ArrayList());
    }

    protected void collectCols(BucketListMap bucketListMap, BucketMap bucketMap) throws JRException {
        if (this.allBuckets[bucketMap.level].computeTotal()) {
            BucketMap bucketMap2 = bucketMap;
            int n = bucketMap.level;
            while (n < this.rowBucketCount) {
                bucketMap2 = (BucketMap)bucketMap2.getTotalEntry().getValue();
                ++n;
            }
            bucketListMap.collectVals(bucketMap2, false);
            return;
        }
        Iterator iterator = bucketMap.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketMap bucketMap3 = (BucketMap)entry.getValue();
            if (bucketMap.level == this.rowBucketCount - 1) {
                bucketListMap.collectVals(bucketMap3, false);
                continue;
            }
            this.collectCols(bucketListMap, bucketMap3);
        }
    }

    protected CollectedList createHeadersList(byte by, BucketMap bucketMap, int n, boolean bl) {
        CollectedList collectedList = new CollectedList();
        Iterator iterator = bucketMap.entryIterator();
        while (iterator.hasNext()) {
            CollectedList collectedList2;
            boolean bl2;
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketDefinition.Bucket bucket = (BucketDefinition.Bucket)entry.getKey();
            boolean bl3 = bucket.isTotal();
            byte by2 = this.allBuckets[bucketMap.level].getTotalPosition();
            boolean bl4 = bl2 = !bl3 || bl || by2 != 0;
            if (!bl2) continue;
            if (n + 1 < this.buckets[by].length) {
                BucketMap bucketMap2 = (BucketMap)entry.getValue();
                collectedList2 = this.createHeadersList(by, bucketMap2, n + 1, bl || bl3);
            } else {
                collectedList2 = new CollectedList();
                collectedList2.span = 1;
            }
            collectedList2.key = bucket;
            if (bl3) {
                if (by2 == 1) {
                    collectedList.addFirst(collectedList2);
                    continue;
                }
                collectedList.add(collectedList2);
                continue;
            }
            collectedList.add(collectedList2);
        }
        if (collectedList.span == 0) {
            collectedList.span = 1;
        }
        return collectedList;
    }

    protected HeaderCell[][] createHeaders(byte by, CollectedList[] collectedListArray) {
        HeaderCell[][] headerCellArray = new HeaderCell[this.buckets[by].length][collectedListArray[by].span];
        ArrayList arrayList = new ArrayList();
        this.fillHeaders(by, headerCellArray, 0, 0, collectedListArray[by], arrayList);
        return headerCellArray;
    }

    protected void fillHeaders(byte by, HeaderCell[][] headerCellArray, int n, int n2, CollectedList collectedList, List list) {
        if (n == this.buckets[by].length) {
            return;
        }
        for (CollectedList collectedList2 : collectedList) {
            list.add(collectedList2.key);
            int n3 = collectedList2.key.isTotal() ? this.buckets[by].length - n : 1;
            BucketDefinition.Bucket[] bucketArray = new BucketDefinition.Bucket[this.buckets[by].length];
            list.toArray(bucketArray);
            headerCellArray[n][n2] = new HeaderCell(bucketArray, collectedList2.span, n3);
            if (!collectedList2.key.isTotal()) {
                this.fillHeaders(by, headerCellArray, n + 1, n2, collectedList2, list);
            }
            n2 += collectedList2.span;
            list.remove(list.size() - 1);
        }
    }

    protected void fillCells(CollectedList[] collectedListArray, BucketMap bucketMap, int n, int[] nArray, List list, List list2) {
        int n2;
        list2.add(bucketMap);
        int n3 = n < this.rowBucketCount ? 0 : 1;
        boolean bl = n == this.allBuckets.length - 1;
        CollectedList[] collectedListArray2 = null;
        if (!bl) {
            collectedListArray2 = new CollectedList[2];
            n2 = 0;
            while (n2 < 2) {
                if (n2 != n3) {
                    collectedListArray2[n2] = collectedListArray[n2];
                }
                ++n2;
            }
        }
        n2 = n == this.buckets[0].length - 1 ? 1 : 0;
        CollectedList collectedList = collectedListArray[n3];
        Iterator iterator = bucketMap == null ? null : bucketMap.entryIterator();
        Map.Entry entry = iterator != null && iterator.hasNext() ? (Map.Entry)iterator.next() : null;
        for (CollectedList collectedList2 : collectedList) {
            Map.Entry entry2 = null;
            if (collectedList2.key.isTotal()) {
                if (bucketMap != null) {
                    entry2 = bucketMap.getTotalEntry();
                }
            } else if (entry != null && entry.getKey().equals(collectedList2.key)) {
                entry2 = entry;
                entry = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
            }
            list.add(collectedList2.key);
            if (bl) {
                this.fillCell(nArray, list, list2, entry2);
            } else {
                collectedListArray2[n3] = collectedList2;
                BucketMap bucketMap2 = entry2 == null ? null : (BucketMap)entry2.getValue();
                this.fillCells(collectedListArray2, bucketMap2, n + 1, nArray, list, list2);
            }
            list.remove(list.size() - 1);
            if (n2 == 0) continue;
            nArray[0] = nArray[0] + 1;
            nArray[1] = 0;
        }
        list2.remove(list2.size() - 1);
    }

    protected void fillCell(int[] nArray, List list, List list2, Map.Entry entry) {
        Iterator iterator = list.iterator();
        BucketDefinition.Bucket[] bucketArray = new BucketDefinition.Bucket[this.buckets[0].length];
        int n = 0;
        while (n < bucketArray.length) {
            bucketArray[n] = (BucketDefinition.Bucket)iterator.next();
            ++n;
        }
        BucketDefinition.Bucket[] bucketArray2 = new BucketDefinition.Bucket[this.buckets[1].length];
        int n2 = 0;
        while (n2 < bucketArray2.length) {
            bucketArray2[n2] = (BucketDefinition.Bucket)iterator.next();
            ++n2;
        }
        MeasureDefinition.MeasureValue[] measureValueArray = entry == null ? this.zeroUserMeasureValues : this.getUserMeasureValues((MeasureDefinition.MeasureValue[])entry.getValue());
        MeasureDefinition.MeasureValue[][][] measureValueArray2 = this.retrieveTotals(list, list2);
        this.cells[nArray[0]][nArray[1]] = new CrosstabCell(bucketArray, bucketArray2, measureValueArray, measureValueArray2);
        nArray[1] = nArray[1] + 1;
    }

    protected MeasureDefinition.MeasureValue[][][] retrieveTotals(List list, List list2) {
        MeasureDefinition.MeasureValue[][][] measureValueArray = new MeasureDefinition.MeasureValue[this.rowBucketCount + 1][this.colBucketCount + 1][];
        int n = this.rowRetrTotalMax;
        while (n >= this.rowRetrTotalMin) {
            if (this.rowRetrTotals[n]) {
                Object object;
                BucketMap bucketMap = (BucketMap)list2.get(n);
                int n2 = n;
                while (bucketMap != null && n2 < this.rowBucketCount) {
                    object = bucketMap.getTotalEntry();
                    bucketMap = object == null ? null : (BucketMap)object.getValue();
                    ++n2;
                }
                n2 = 0;
                while (n2 <= this.rowRetrColMax[n]) {
                    object = bucketMap;
                    if (n2 < this.colBucketCount - 1) {
                        if (n == this.rowBucketCount) {
                            bucketMap = (BucketMap)list2.get(this.rowBucketCount + n2 + 1);
                        } else if (bucketMap != null) {
                            bucketMap = (BucketMap)bucketMap.get((BucketDefinition.Bucket)list.get(this.rowBucketCount + n2));
                        }
                    }
                    if (this.retrieveTotal[n][n2]) {
                        int n3 = n2 + 1;
                        while (object != null && n3 < this.colBucketCount) {
                            object = (BucketMap)((BucketMap)object).getTotalEntry().getValue();
                            ++n3;
                        }
                        if (object != null) {
                            if (n2 == this.colBucketCount) {
                                MeasureDefinition.MeasureValue[] measureValueArray2 = (MeasureDefinition.MeasureValue[])((BucketMap)object).get((BucketDefinition.Bucket)list.get(this.rowBucketCount + this.colBucketCount - 1));
                                measureValueArray[n][n2] = this.getUserMeasureValues(measureValueArray2);
                            } else {
                                Map.Entry entry = ((BucketMap)object).getTotalEntry();
                                if (entry != null) {
                                    MeasureDefinition.MeasureValue[] measureValueArray3 = (MeasureDefinition.MeasureValue[])entry.getValue();
                                    measureValueArray[n][n2] = this.getUserMeasureValues(measureValueArray3);
                                }
                            }
                        }
                        if (measureValueArray[n][n2] == null) {
                            measureValueArray[n][n2] = this.zeroUserMeasureValues;
                        }
                    }
                    ++n2;
                }
            }
            --n;
        }
        return measureValueArray;
    }

    protected class BucketListMap
    extends BucketMap {
        List entries;

        BucketListMap(int n, boolean bl) {
            super(n);
            this.entries = bl ? new LinkedList() : new ArrayList();
        }

        void clear() {
            this.entries.clear();
        }

        Iterator entryIterator() {
            return this.entries.iterator();
        }

        private void add(BucketDefinition.Bucket bucket, Object object) {
            this.entries.add(new MapEntry(bucket, object));
        }

        Object get(BucketDefinition.Bucket bucket) {
            int n = Collections.binarySearch(this.entries, new MapEntry(bucket, null));
            return n >= 0 ? ((MapEntry)this.entries.get((int)n)).value : null;
        }

        /*
         * Unable to fully structure code
         */
        MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] var1_1) {
            var2_2 = 0;
            var3_3 = this;
            var4_4 = null;
            while (var2_2 < BucketingService.this.allBuckets.length) {
                var4_4 = var3_3;
                var5_5 = var4_4.entries.size();
                if (var5_5 == 0) break;
                var6_8 = (MapEntry)var4_4.entries.get(var5_5 - 1);
                if (!var6_8.key.equals(var1_1[var2_2])) break;
                ++var2_2;
                var3_3 = var6_8.value;
            }
            if (var2_2 != BucketingService.this.allBuckets.length) ** GOTO lbl19
            return (MeasureDefinition.MeasureValue[])var3_3;
lbl-1000:
            // 1 sources

            {
                var5_6 = new BucketListMap(var2_2 + 1, false);
                var4_4.add(var1_1[var2_2], var5_6);
                var4_4 = var5_6;
                ++var2_2;
lbl19:
                // 2 sources

                ** while (var2_2 < BucketingService.this.allBuckets.length - 1)
            }
lbl20:
            // 1 sources

            var5_7 = BucketingService.this.initMeasureValues();
            var4_4.add(var1_1[var2_2], var5_7);
            return var5_7;
        }

        int size() {
            return this.entries.size();
        }

        void addTotalEntry(Object object) {
            this.add(this.totalKey, object);
        }

        Map.Entry getTotalEntry() {
            MapEntry mapEntry = (MapEntry)this.entries.get(this.entries.size() - 1);
            if (mapEntry.key.isTotal()) {
                return mapEntry;
            }
            return null;
        }

        void set(BucketDefinition.Bucket bucket, Object object) {
            MapEntry mapEntry = new MapEntry(bucket, object);
            int n = Collections.binarySearch(this.entries, mapEntry);
            int n2 = -n - 1;
            this.entries.add(n2, mapEntry);
        }

        void collectVals(BucketMap bucketMap, boolean bl) throws JRException {
            ListIterator<MapEntry> listIterator = this.entries.listIterator();
            MapEntry mapEntry = listIterator.hasNext() ? (MapEntry)listIterator.next() : null;
            Iterator iterator = bucketMap.entryIterator();
            Map.Entry entry = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
            while (entry != null) {
                int n;
                BucketDefinition.Bucket bucket = (BucketDefinition.Bucket)entry.getKey();
                int n2 = n = mapEntry == null ? -1 : bucket.compareTo(mapEntry.key);
                if (n <= 0) {
                    Object object;
                    MeasureDefinition.MeasureValue[] measureValueArray = null;
                    if (this.last) {
                        if (bl) {
                            MeasureDefinition.MeasureValue[] measureValueArray2 = object = n == 0 ? (MeasureDefinition.MeasureValue[])mapEntry.value : null;
                            if (object == null) {
                                measureValueArray = object = BucketingService.this.initMeasureValues();
                            }
                            BucketingService.this.sumVals((MeasureDefinition.MeasureValue[])object, (MeasureDefinition.MeasureValue[])entry.getValue());
                        }
                    } else {
                        MeasureDefinition.MeasureValue[] measureValueArray3 = object = n == 0 ? (MeasureDefinition.MeasureValue[])mapEntry.value : null;
                        if (object == null) {
                            measureValueArray = object = BucketingService.this.createCollectBucketMap(this.level + 1);
                        }
                        object.collectVals((BucketMap)entry.getValue(), bl);
                    }
                    if (n < 0) {
                        if (mapEntry != null) {
                            listIterator.previous();
                        }
                        listIterator.add(new MapEntry(bucket, measureValueArray));
                        if (mapEntry != null) {
                            listIterator.next();
                        }
                    }
                    Map.Entry entry2 = entry = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
                }
                if (n < 0) continue;
                MapEntry mapEntry2 = mapEntry = listIterator.hasNext() ? (MapEntry)listIterator.next() : null;
            }
        }
    }

    protected abstract class BucketMap {
        final int level;
        final boolean last;
        final BucketDefinition.Bucket totalKey;

        BucketMap(int n) {
            this.level = n;
            this.last = n == BucketingService.this.allBuckets.length - 1;
            this.totalKey = BucketingService.this.allBuckets[n].VALUE_TOTAL;
        }

        BucketMap addTotalNextMap() {
            BucketMap bucketMap = BucketingService.this.createBucketMap(this.level + 1);
            this.addTotalEntry(bucketMap);
            return bucketMap;
        }

        abstract void set(BucketDefinition.Bucket var1, Object var2);

        abstract void clear();

        abstract Iterator entryIterator();

        abstract Object get(BucketDefinition.Bucket var1);

        abstract MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] var1);

        abstract void addTotalEntry(Object var1);

        abstract int size();

        abstract Map.Entry getTotalEntry();
    }

    protected class BucketTreeMap
    extends BucketMap {
        TreeMap map;

        BucketTreeMap(int n) {
            super(n);
            this.map = new TreeMap();
        }

        void clear() {
            this.map.clear();
        }

        Iterator entryIterator() {
            return this.map.entrySet().iterator();
        }

        Object get(BucketDefinition.Bucket bucket) {
            return this.map.get(bucket);
        }

        MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] bucketArray) {
            BucketTreeMap bucketTreeMap = (BucketTreeMap)BucketingService.this.bucketValueMap;
            int n = 0;
            while (n < bucketArray.length - 1) {
                BucketTreeMap bucketTreeMap2 = (BucketTreeMap)bucketTreeMap.get(bucketArray[n]);
                if (bucketTreeMap2 == null) {
                    bucketTreeMap2 = new BucketTreeMap(n + 1);
                    bucketTreeMap.map.put(bucketArray[n], bucketTreeMap2);
                }
                bucketTreeMap = bucketTreeMap2;
                ++n;
            }
            MeasureDefinition.MeasureValue[] measureValueArray = (MeasureDefinition.MeasureValue[])bucketTreeMap.get(bucketArray[bucketArray.length - 1]);
            if (measureValueArray == null) {
                measureValueArray = BucketingService.this.initMeasureValues();
                bucketTreeMap.map.put(bucketArray[bucketArray.length - 1], measureValueArray);
            }
            return measureValueArray;
        }

        int size() {
            return this.map.size();
        }

        void addTotalEntry(Object object) {
            this.map.put(this.totalKey, object);
        }

        Map.Entry getTotalEntry() {
            Object object = this.get(this.totalKey);
            return object == null ? null : new MapEntry(this.totalKey, object);
        }

        public String toString() {
            return this.map.toString();
        }

        void set(BucketDefinition.Bucket bucket, Object object) {
            this.map.put(bucket, object);
        }
    }

    protected static class CollectedList
    extends LinkedList {
        int span = 0;
        BucketDefinition.Bucket key;

        CollectedList() {
        }

        public boolean add(Object object) {
            boolean bl = super.add(object);
            this.incrementSpan(object);
            return bl;
        }

        public void addFirst(Object object) {
            super.addFirst(object);
            this.incrementSpan(object);
        }

        public void addLast(Object object) {
            super.add(object);
            this.incrementSpan(object);
        }

        private void incrementSpan(Object object) {
            this.span = object != null && object instanceof CollectedList ? (this.span += ((CollectedList)object).span) : ++this.span;
        }

        public String toString() {
            return this.key + "/" + this.span + ": " + super.toString();
        }
    }

    protected static class MapEntry
    implements Map.Entry,
    Comparable {
        final BucketDefinition.Bucket key;
        final Object value;

        MapEntry(BucketDefinition.Bucket bucket, Object object) {
            this.key = bucket;
            this.value = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object object) {
            return this.key.compareTo(((MapEntry)object).key);
        }

        public String toString() {
            return this.key + ":" + this.value;
        }
    }
}

