package serpro.ppgd.irpf;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCNPJ;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ItemQuadroOutrosRendimentos extends ObjetoNegocio
{
  private CPF cpfBenefic = new CPF (this, "CPF");
  private Alfa especificacao = new Alfa (this, "Descrição do rendimento", 60);
  private Valor valor = new Valor (this, "Valor do recebimento");
  private Alfa nomeFonte = new Alfa (this, "Nome da fonte pagadora", 60);
  private CNPJ cnpjEmpresa = new CNPJ (this, "CNPJ da Empresa");
  private transient DeclaracaoIRPF objDecl;

  public ItemQuadroOutrosRendimentos (final DeclaracaoIRPF objDecl)
  {
    this.objDecl = objDecl;
    getCpfBenefic ().setConteudo (objDecl.getIdentificadorDeclaracao ().getCpf ().asString ());
    getCnpjEmpresa ().addValidador (new ValidadorNaoNulo ((byte) 3));
    getCnpjEmpresa ().addValidador (new ValidadorCNPJ ((byte) 3));
    getEspecificacao ().addValidador (new ValidadorNaoNulo ((byte) 3));
    getValor ().addValidador (new ValidadorNaoNulo ((byte) 3));
    getCpfBenefic ().addValidador (new ValidadorCPF ((byte) 3));
    getCpfBenefic ().addValidador (new ValidadorDefault ((byte) 3)
      {
	public RetornoValidacao validarImplementado ()
	{
	  System.out.println("testando cpf");
	  if (isMissingBenefic ())
	    return new RetornoValidacao (tab.msg ("cpf_branco"));
	  /* FIXME: Os totalizadores só funcionam corretamente se
	     todos os outros rendimentos forem do titular.  */
	  if (!isTitular () /* && !isDependente () */)
	    return new RetornoValidacao (tab.msg ("rend_outros_cpf"));
	  return null;
	}
      });
  }

  public CPF getCpfBenefic ()
  {
    return cpfBenefic;
  }

  public Alfa getEspecificacao ()
  {
    return especificacao;
  }

  public Valor getValor ()
  {
    return valor;
  }

  public Alfa getNomeFonte ()
  {
    return nomeFonte;
  }

  public CNPJ getCnpjEmpresa ()
  {
    return cnpjEmpresa;
  }

  public boolean isMissingBenefic (final String cpf)
  {
    return cpf.equals ("") || cpf.equals ("   .   .   -  ");
  }

  public boolean isMissingBenefic ()
  {
    String cpf = getCpfBenefic ().asString ();
    return isMissingBenefic (cpf);
  }

  public boolean isTitular ()
  {
    String cpf = getCpfBenefic ().asString ();
    return (isMissingBenefic (cpf) ||
	    cpf.equals (objDecl.getIdentificadorDeclaracao ().getCpf ().asString ()));
  }

  public boolean isDependente ()
  {
    return (!isTitular ()
	    && (objDecl.getDependentes ().getDependenteByCPF (getCpfBenefic ())
		!= null));
  }
}
