/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.fill.JRFillXyzSeries;
import net.sf.jasperreports.charts.util.DefaultXYZDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.jfree.data.general.Dataset;

public class JRFillXyzDataset
extends JRFillChartDataset
implements JRXyzDataset {
    protected JRFillXyzSeries[] xyzSeries = null;
    private DefaultXYZDataset dataset = null;
    private Map itemHyperlinks;

    public JRFillXyzDataset(JRXyzDataset jRXyzDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRXyzDataset, jRFillObjectFactory);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            this.xyzSeries = new JRFillXyzSeries[jRXyzSeriesArray.length];
            int n = 0;
            while (n < this.xyzSeries.length) {
                this.xyzSeries[n] = (JRFillXyzSeries)jRFillObjectFactory.getXyzSeries(jRXyzSeriesArray[n]);
                ++n;
            }
        }
    }

    public JRXyzSeries[] getSeries() {
        return this.xyzSeries;
    }

    protected void customInitialize() {
        this.dataset = new DefaultXYZDataset();
        this.itemHyperlinks = new HashMap();
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            int n = 0;
            while (n < this.xyzSeries.length) {
                this.xyzSeries[n].evaluate(jRCalculator);
                ++n;
            }
        }
    }

    protected void customIncrement() {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            int n = 0;
            while (n < this.xyzSeries.length) {
                JRFillXyzSeries jRFillXyzSeries = this.xyzSeries[n];
                this.dataset.addValue(jRFillXyzSeries.getSeries(), jRFillXyzSeries.getXValue(), jRFillXyzSeries.getYValue(), jRFillXyzSeries.getZValue());
                if (jRFillXyzSeries.hasItemHyperlinks()) {
                    HashMap<Pair, JRPrintHyperlink> hashMap = (HashMap<Pair, JRPrintHyperlink>)this.itemHyperlinks.get(jRFillXyzSeries.getSeries());
                    if (hashMap == null) {
                        hashMap = new HashMap<Pair, JRPrintHyperlink>();
                        this.itemHyperlinks.put(jRFillXyzSeries.getSeries(), hashMap);
                    }
                    Pair pair = new Pair(jRFillXyzSeries.getXValue(), jRFillXyzSeries.getYValue());
                    hashMap.put(pair, jRFillXyzSeries.getPrintItemHyperlink());
                }
                ++n;
            }
        }
    }

    public Dataset getCustomDataset() {
        return this.dataset;
    }

    public byte getDatasetType() {
        return 4;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public boolean hasItemHyperlinks() {
        boolean bl = false;
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            int n = 0;
            while (n < this.xyzSeries.length && !bl) {
                JRFillXyzSeries jRFillXyzSeries = this.xyzSeries[n];
                bl = jRFillXyzSeries.hasItemHyperlinks();
                ++n;
            }
        }
        return bl;
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

