/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.FormatFactory;

public class JRFillContext {
    private Map loadedImages = new HashMap();
    private boolean usingVirtualizer = false;
    private boolean perPageBoundElements = false;
    private JRPrintPage printPage = null;
    private boolean ignorePagination = false;
    private JRQueryExecuter queryExecuter;
    private JRVirtualizationContext virtualizationContext;
    private FormatFactory masterFormatFactory;
    private Locale masterLocale;
    private TimeZone masterTimeZone;

    public boolean hasLoadedImage(Object object) {
        return this.loadedImages.containsKey(object);
    }

    public JRPrintImage getLoadedImage(Object object) {
        return (JRPrintImage)this.loadedImages.get(object);
    }

    public void registerLoadedImage(Object object, JRPrintImage jRPrintImage) {
        this.loadedImages.put(object, jRPrintImage);
        if (this.usingVirtualizer) {
            this.virtualizationContext.cacheRenderer(jRPrintImage);
        }
    }

    public void setUsingVirtualizer(boolean bl) {
        this.usingVirtualizer = bl;
        if (bl && this.virtualizationContext == null) {
            this.virtualizationContext = new JRVirtualizationContext();
        }
    }

    public boolean isUsingVirtualizer() {
        return this.usingVirtualizer;
    }

    public void setPerPageBoundElements(boolean bl) {
        this.perPageBoundElements = bl;
    }

    public boolean isPerPageBoundElements() {
        return this.perPageBoundElements;
    }

    public void setPrintPage(JRPrintPage jRPrintPage) {
        this.printPage = jRPrintPage;
    }

    public JRPrintPage getPrintPage() {
        return this.printPage;
    }

    public void setIgnorePagination(boolean bl) {
        this.ignorePagination = bl;
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public synchronized void setRunningQueryExecuter(JRQueryExecuter jRQueryExecuter) {
        this.queryExecuter = jRQueryExecuter;
    }

    public synchronized void clearRunningQueryExecuter() {
        this.queryExecuter = null;
    }

    public synchronized boolean cancelRunningQuery() throws JRException {
        if (this.queryExecuter != null) {
            return this.queryExecuter.cancelQuery();
        }
        return false;
    }

    public void ensureMasterPageAvailable() {
        if (this.usingVirtualizer) {
            this.printPage.getElements();
        }
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.virtualizationContext;
    }

    public FormatFactory getMasterFormatFactory() {
        return this.masterFormatFactory;
    }

    public void setMasterFormatFactory(FormatFactory formatFactory) {
        this.masterFormatFactory = formatFactory;
    }

    public Locale getMasterLocale() {
        return this.masterLocale;
    }

    public void setMasterLocale(Locale locale) {
        this.masterLocale = locale;
    }

    public TimeZone getMasterTimeZone() {
        return this.masterTimeZone;
    }

    public void setMasterTimeZone(TimeZone timeZone) {
        this.masterTimeZone = timeZone;
    }
}

