/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class DocumentFont
extends BaseFont {
    private HashMap metrics = new HashMap();
    private String fontName;
    private PRIndirectReference refFont;
    private PdfDictionary font;
    private IntHashtable uni2byte = new IntHashtable();
    private float Ascender = 800.0f;
    private float CapHeight = 700.0f;
    private float Descender = -200.0f;
    private float ItalicAngle = 0.0f;
    private float llx = -50.0f;
    private float lly = -200.0f;
    private float urx = 100.0f;
    private float ury = 900.0f;
    private boolean isType0 = false;
    private BaseFont cjkMirror;
    private static String[] cjkNames = new String[]{"HeiseiMin-W3", "HeiseiKakuGo-W5", "STSong-Light", "MHei-Medium", "MSung-Light", "HYGoThic-Medium", "HYSMyeongJo-Medium", "MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs = new String[]{"UniJIS-UCS2-H", "UniJIS-UCS2-H", "UniGB-UCS2-H", "UniCNS-UCS2-H", "UniCNS-UCS2-H", "UniKS-UCS2-H", "UniKS-UCS2-H", "UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H"};
    private static String[] cjkNames2 = new String[]{"MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs2 = new String[]{"UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H", "UniCNS-UTF16-H", "UniGB-UTF16-H", "UniKS-UTF16-H", "UniJIS-UTF16-H"};
    private static final int[] stdEnc;

    static {
        int[] nArray = new int[256];
        nArray[32] = 32;
        nArray[33] = 33;
        nArray[34] = 34;
        nArray[35] = 35;
        nArray[36] = 36;
        nArray[37] = 37;
        nArray[38] = 38;
        nArray[39] = 8217;
        nArray[40] = 40;
        nArray[41] = 41;
        nArray[42] = 42;
        nArray[43] = 43;
        nArray[44] = 44;
        nArray[45] = 45;
        nArray[46] = 46;
        nArray[47] = 47;
        nArray[48] = 48;
        nArray[49] = 49;
        nArray[50] = 50;
        nArray[51] = 51;
        nArray[52] = 52;
        nArray[53] = 53;
        nArray[54] = 54;
        nArray[55] = 55;
        nArray[56] = 56;
        nArray[57] = 57;
        nArray[58] = 58;
        nArray[59] = 59;
        nArray[60] = 60;
        nArray[61] = 61;
        nArray[62] = 62;
        nArray[63] = 63;
        nArray[64] = 64;
        nArray[65] = 65;
        nArray[66] = 66;
        nArray[67] = 67;
        nArray[68] = 68;
        nArray[69] = 69;
        nArray[70] = 70;
        nArray[71] = 71;
        nArray[72] = 72;
        nArray[73] = 73;
        nArray[74] = 74;
        nArray[75] = 75;
        nArray[76] = 76;
        nArray[77] = 77;
        nArray[78] = 78;
        nArray[79] = 79;
        nArray[80] = 80;
        nArray[81] = 81;
        nArray[82] = 82;
        nArray[83] = 83;
        nArray[84] = 84;
        nArray[85] = 85;
        nArray[86] = 86;
        nArray[87] = 87;
        nArray[88] = 88;
        nArray[89] = 89;
        nArray[90] = 90;
        nArray[91] = 91;
        nArray[92] = 92;
        nArray[93] = 93;
        nArray[94] = 94;
        nArray[95] = 95;
        nArray[96] = 8216;
        nArray[97] = 97;
        nArray[98] = 98;
        nArray[99] = 99;
        nArray[100] = 100;
        nArray[101] = 101;
        nArray[102] = 102;
        nArray[103] = 103;
        nArray[104] = 104;
        nArray[105] = 105;
        nArray[106] = 106;
        nArray[107] = 107;
        nArray[108] = 108;
        nArray[109] = 109;
        nArray[110] = 110;
        nArray[111] = 111;
        nArray[112] = 112;
        nArray[113] = 113;
        nArray[114] = 114;
        nArray[115] = 115;
        nArray[116] = 116;
        nArray[117] = 117;
        nArray[118] = 118;
        nArray[119] = 119;
        nArray[120] = 120;
        nArray[121] = 121;
        nArray[122] = 122;
        nArray[123] = 123;
        nArray[124] = 124;
        nArray[125] = 125;
        nArray[126] = 126;
        nArray[161] = 161;
        nArray[162] = 162;
        nArray[163] = 163;
        nArray[164] = 8260;
        nArray[165] = 165;
        nArray[166] = 402;
        nArray[167] = 167;
        nArray[168] = 164;
        nArray[169] = 39;
        nArray[170] = 8220;
        nArray[171] = 171;
        nArray[172] = 8249;
        nArray[173] = 8250;
        nArray[174] = 64257;
        nArray[175] = 64258;
        nArray[177] = 8211;
        nArray[178] = 8224;
        nArray[179] = 8225;
        nArray[180] = 183;
        nArray[182] = 182;
        nArray[183] = 8226;
        nArray[184] = 8218;
        nArray[185] = 8222;
        nArray[186] = 8221;
        nArray[187] = 187;
        nArray[188] = 8230;
        nArray[189] = 8240;
        nArray[191] = 191;
        nArray[193] = 96;
        nArray[194] = 180;
        nArray[195] = 710;
        nArray[196] = 732;
        nArray[197] = 175;
        nArray[198] = 728;
        nArray[199] = 729;
        nArray[200] = 168;
        nArray[202] = 730;
        nArray[203] = 184;
        nArray[205] = 733;
        nArray[206] = 731;
        nArray[207] = 711;
        nArray[208] = 8212;
        nArray[225] = 198;
        nArray[227] = 170;
        nArray[232] = 321;
        nArray[233] = 216;
        nArray[234] = 338;
        nArray[235] = 186;
        nArray[241] = 230;
        nArray[245] = 305;
        nArray[248] = 322;
        nArray[249] = 248;
        nArray[250] = 339;
        nArray[251] = 223;
        stdEnc = nArray;
    }

    DocumentFont(PRIndirectReference pRIndirectReference) {
        this.encoding = "";
        this.fontSpecific = false;
        this.refFont = pRIndirectReference;
        this.fontType = 4;
        this.font = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        this.fontName = PdfName.decodeName(((PdfName)PdfReader.getPdfObject(this.font.get(PdfName.BASEFONT))).toString());
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(this.font.get(PdfName.SUBTYPE));
        if (PdfName.TYPE1.equals(pdfName) || PdfName.TRUETYPE.equals(pdfName)) {
            this.doType1TT();
        } else {
            int n = 0;
            while (n < cjkNames.length) {
                if (this.fontName.startsWith(cjkNames[n])) {
                    this.fontName = cjkNames[n];
                    try {
                        this.cjkMirror = BaseFont.createFont(this.fontName, cjkEncs[n], false);
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                    return;
                }
                ++n;
            }
            String string = PdfName.decodeName(((PdfName)PdfReader.getPdfObject(this.font.get(PdfName.ENCODING))).toString());
            int n2 = 0;
            while (n2 < cjkEncs2.length) {
                if (string.startsWith(cjkEncs2[n2])) {
                    try {
                        if (n2 > 3) {
                            n2 -= 4;
                        }
                        this.cjkMirror = BaseFont.createFont(cjkNames2[n2], cjkEncs2[n2], false);
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                    return;
                }
                ++n2;
            }
            if (PdfName.TYPE0.equals(pdfName) && string.equals("Identity-H")) {
                this.processType0(this.font);
                this.isType0 = true;
            }
        }
    }

    private void processType0(PdfDictionary pdfDictionary) {
        try {
            byte[] byArray = PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.TOUNICODE)));
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.DESCENDANTFONTS));
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)pdfArray.getArrayList().get(0));
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.DW));
            int n = 1000;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            IntHashtable intHashtable = this.readWidths((PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.W)));
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.FONTDESCRIPTOR));
            this.fillFontDesc(pdfDictionary3);
            this.fillMetrics(byArray, intHashtable, n);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private IntHashtable readWidths(PdfArray pdfArray) {
        IntHashtable intHashtable = new IntHashtable();
        if (pdfArray == null) {
            return intHashtable;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            PdfObject pdfObject;
            int n3 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n))).intValue();
            if ((pdfObject = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(++n))).isArray()) {
                ArrayList arrayList2 = ((PdfArray)pdfObject).getArrayList();
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    int n4 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList2.get(n2))).intValue();
                    intHashtable.put(n3++, n4);
                    ++n2;
                }
            } else {
                int n5 = ((PdfNumber)pdfObject).intValue();
                n2 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(++n))).intValue();
                while (n3 <= n5) {
                    intHashtable.put(n3, n2);
                    ++n3;
                }
            }
            ++n;
        }
        return intHashtable;
    }

    private String decodeString(PdfString pdfString) {
        if (pdfString.isHexWriting()) {
            return PdfEncodings.convertToString(pdfString.getBytes(), "UnicodeBigUnmarked");
        }
        return pdfString.toUnicodeString();
    }

    private void fillMetrics(byte[] byArray, IntHashtable intHashtable, int n) {
        try {
            PdfContentParser pdfContentParser = new PdfContentParser(new PRTokeniser(byArray));
            PdfObject pdfObject = null;
            PdfObject pdfObject2 = null;
            while ((pdfObject = pdfContentParser.readPRObject()) != null) {
                if (pdfObject.type() == 200) {
                    char c;
                    int n2;
                    String string;
                    String string2;
                    int n3;
                    int n4;
                    if (pdfObject.toString().equals("beginbfchar")) {
                        n4 = ((PdfNumber)pdfObject2).intValue();
                        n3 = 0;
                        while (n3 < n4) {
                            string2 = this.decodeString((PdfString)pdfContentParser.readPRObject());
                            string = this.decodeString((PdfString)pdfContentParser.readPRObject());
                            if (string.length() == 1) {
                                n2 = string2.charAt(0);
                                c = string.charAt(string.length() - 1);
                                int n5 = n;
                                if (intHashtable.containsKey(n2)) {
                                    n5 = intHashtable.get(n2);
                                }
                                this.metrics.put(new Integer(c), new int[]{n2, n5});
                            }
                            ++n3;
                        }
                        continue;
                    }
                    if (!pdfObject.toString().equals("beginbfrange")) continue;
                    n4 = ((PdfNumber)pdfObject2).intValue();
                    n3 = 0;
                    while (n3 < n4) {
                        int n6;
                        Object object;
                        string2 = this.decodeString((PdfString)pdfContentParser.readPRObject());
                        string = this.decodeString((PdfString)pdfContentParser.readPRObject());
                        n2 = string2.charAt(0);
                        c = string.charAt(0);
                        PdfObject pdfObject3 = pdfContentParser.readPRObject();
                        if (pdfObject3.isString()) {
                            object = this.decodeString((PdfString)pdfObject3);
                            if (((String)object).length() == 1) {
                                n6 = ((String)object).charAt(((String)object).length() - 1);
                                while (n2 <= c) {
                                    int n7 = n;
                                    if (intHashtable.containsKey(n2)) {
                                        n7 = intHashtable.get(n2);
                                    }
                                    this.metrics.put(new Integer(n6), new int[]{n2++, n7});
                                    ++n6;
                                }
                            }
                        } else {
                            object = ((PdfArray)pdfObject3).getArrayList();
                            n6 = 0;
                            while (n6 < ((ArrayList)object).size()) {
                                String string3 = this.decodeString((PdfString)((ArrayList)object).get(n6));
                                if (string3.length() == 1) {
                                    char c2 = string3.charAt(string3.length() - 1);
                                    int n8 = n;
                                    if (intHashtable.containsKey(n2)) {
                                        n8 = intHashtable.get(n2);
                                    }
                                    this.metrics.put(new Integer(c2), new int[]{n2, n8});
                                }
                                ++n6;
                                ++n2;
                            }
                        }
                        ++n3;
                    }
                    continue;
                }
                pdfObject2 = pdfObject;
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private void doType1TT() {
        Object object;
        PdfObject pdfObject;
        PdfObject pdfObject2;
        PdfObject pdfObject3 = PdfReader.getPdfObject(this.font.get(PdfName.ENCODING));
        if (pdfObject3 == null) {
            this.fillEncoding(null);
        } else if (pdfObject3.isName()) {
            this.fillEncoding((PdfName)pdfObject3);
        } else {
            pdfObject2 = (PdfDictionary)pdfObject3;
            if ((pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.BASEENCODING))) == null) {
                this.fillEncoding(null);
            } else {
                this.fillEncoding((PdfName)pdfObject3);
            }
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.DIFFERENCES));
            if (pdfObject != null) {
                object = ((PdfArray)pdfObject).getArrayList();
                int n = 0;
                int n2 = 0;
                while (n2 < ((ArrayList)object).size()) {
                    PdfObject pdfObject4 = (PdfObject)((ArrayList)object).get(n2);
                    if (pdfObject4.isNumber()) {
                        n = ((PdfNumber)pdfObject4).intValue();
                    } else {
                        int[] nArray = GlyphList.nameToUnicode(PdfName.decodeName(((PdfName)pdfObject4).toString()));
                        if (nArray != null && nArray.length > 0) {
                            this.uni2byte.put(nArray[0], n);
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
        }
        pdfObject2 = (PdfArray)PdfReader.getPdfObject(this.font.get(PdfName.WIDTHS));
        pdfObject = (PdfNumber)PdfReader.getPdfObject(this.font.get(PdfName.FIRSTCHAR));
        object = (PdfNumber)PdfReader.getPdfObject(this.font.get(PdfName.LASTCHAR));
        if (BuiltinFonts14.containsKey(this.fontName)) {
            BaseFont baseFont;
            try {
                baseFont = BaseFont.createFont(this.fontName, "Cp1252", false);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            int[] nArray = this.uni2byte.toOrderedKeys();
            int n = 0;
            while (n < nArray.length) {
                int n3 = this.uni2byte.get(nArray[n]);
                this.widths[n3] = baseFont.getRawWidth(n3, GlyphList.unicodeToName(nArray[n]));
                ++n;
            }
            this.Ascender = baseFont.getFontDescriptor(1, 1000.0f);
            this.CapHeight = baseFont.getFontDescriptor(2, 1000.0f);
            this.Descender = baseFont.getFontDescriptor(3, 1000.0f);
            this.ItalicAngle = baseFont.getFontDescriptor(4, 1000.0f);
            this.llx = baseFont.getFontDescriptor(5, 1000.0f);
            this.lly = baseFont.getFontDescriptor(6, 1000.0f);
            this.urx = baseFont.getFontDescriptor(7, 1000.0f);
            this.ury = baseFont.getFontDescriptor(8, 1000.0f);
        }
        if (pdfObject != null && object != null && pdfObject2 != null) {
            int n = ((PdfNumber)pdfObject).intValue();
            ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                this.widths[n + n4] = ((PdfNumber)arrayList.get(n4)).intValue();
                ++n4;
            }
        }
        this.fillFontDesc((PdfDictionary)PdfReader.getPdfObject(this.font.get(PdfName.FONTDESCRIPTOR)));
    }

    private void fillFontDesc(PdfDictionary pdfDictionary) {
        PdfArray pdfArray;
        if (pdfDictionary == null) {
            return;
        }
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ASCENT));
        if (pdfNumber != null) {
            this.Ascender = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CAPHEIGHT))) != null) {
            this.CapHeight = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESCENT))) != null) {
            this.Descender = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ITALICANGLE))) != null) {
            this.ItalicAngle = pdfNumber.floatValue();
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTBBOX))) != null) {
            float f;
            ArrayList arrayList = pdfArray.getArrayList();
            this.llx = ((PdfNumber)arrayList.get(0)).floatValue();
            this.lly = ((PdfNumber)arrayList.get(1)).floatValue();
            this.urx = ((PdfNumber)arrayList.get(2)).floatValue();
            this.ury = ((PdfNumber)arrayList.get(3)).floatValue();
            if (this.llx > this.urx) {
                f = this.llx;
                this.llx = this.urx;
                this.urx = f;
            }
            if (this.lly > this.ury) {
                f = this.lly;
                this.lly = this.ury;
                this.ury = f;
            }
        }
    }

    private void fillEncoding(PdfName pdfName) {
        if (PdfName.MAC_ROMAN_ENCODING.equals(pdfName) || PdfName.WIN_ANSI_ENCODING.equals(pdfName)) {
            byte[] byArray = new byte[256];
            int n = 0;
            while (n < 256) {
                byArray[n] = (byte)n;
                ++n;
            }
            String string = "Cp1252";
            if (PdfName.MAC_ROMAN_ENCODING.equals(pdfName)) {
                string = "MacRoman";
            }
            String string2 = PdfEncodings.convertToString(byArray, string);
            char[] cArray = string2.toCharArray();
            int n2 = 0;
            while (n2 < 256) {
                this.uni2byte.put(cArray[n2], n2);
                ++n2;
            }
        } else {
            int n = 0;
            while (n < 256) {
                this.uni2byte.put(stdEnc[n], n);
                ++n;
            }
        }
    }

    public String[][] getFamilyFontName() {
        return null;
    }

    public float getFontDescriptor(int n, float f) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getFontDescriptor(n, f);
        }
        switch (n) {
            case 1: 
            case 9: {
                return this.Ascender * f / 1000.0f;
            }
            case 2: {
                return this.CapHeight * f / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.Descender * f / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return this.llx * f / 1000.0f;
            }
            case 6: {
                return this.lly * f / 1000.0f;
            }
            case 7: {
                return this.urx * f / 1000.0f;
            }
            case 8: {
                return this.ury * f / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.urx - this.llx) * f / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return null;
    }

    public int getKerning(char c, char c2) {
        return 0;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    int getRawWidth(int n, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
    }

    public int getWidth(String string) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(string);
        }
        if (this.isType0) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int[] nArray = (int[])this.metrics.get(new Integer(cArray[n3]));
                if (nArray != null) {
                    n2 += nArray[1];
                }
                ++n3;
            }
            return n2;
        }
        return super.getWidth(string);
    }

    byte[] convertToBytes(String string) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes(string, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n * 2];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int[] nArray = (int[])this.metrics.get(new Integer(cArray[n3]));
                if (nArray != null) {
                    int n4 = nArray[0];
                    byArray[n2++] = (byte)(n4 / 256);
                    byArray[n2++] = (byte)n4;
                }
                ++n3;
            }
            if (n2 == byArray.length) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            if (this.uni2byte.containsKey(cArray[n5])) {
                byArray[n++] = (byte)this.uni2byte.get(cArray[n5]);
            }
            ++n5;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        return byArray3;
    }

    PdfIndirectReference getIndirectReference() {
        return this.refFont;
    }

    public boolean charExists(char c) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.charExists(c);
        }
        if (this.isType0) {
            return this.metrics.containsKey(new Integer(c));
        }
        return super.charExists(c);
    }

    public void setPostscriptFontName(String string) {
    }

    public boolean setKerning(char c, char c2, int n) {
        return false;
    }

    public int[] getCharBBox(char c) {
        return null;
    }

    protected int[] getRawCharBBox(int n, String string) {
        return null;
    }
}

