/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.debug.FormDebugUtils;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class FormDebugPanel
extends JPanel {
    private static final Color DEFAULT_GRID_COLOR = Color.red;
    private boolean paintInBackground;
    private boolean paintDiagonals;
    private Color gridColor = DEFAULT_GRID_COLOR;

    public FormDebugPanel() {
        this(null);
    }

    public FormDebugPanel(FormLayout formLayout) {
        this(formLayout, false, false);
    }

    public FormDebugPanel(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public FormDebugPanel(FormLayout formLayout, boolean bl, boolean bl2) {
        super(formLayout);
        this.setPaintInBackground(bl);
        this.setPaintDiagonals(bl2);
        this.setGridColor(DEFAULT_GRID_COLOR);
    }

    public void setPaintInBackground(boolean bl) {
        this.paintInBackground = bl;
    }

    public void setPaintDiagonals(boolean bl) {
        this.paintDiagonals = bl;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.paintInBackground) {
            this.paintGrid(graphics);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.paintInBackground) {
            this.paintGrid(graphics);
        }
    }

    private void paintGrid(Graphics graphics) {
        if (!(this.getLayout() instanceof FormLayout)) {
            return;
        }
        FormLayout.LayoutInfo layoutInfo = FormDebugUtils.getLayoutInfo(this);
        int n = layoutInfo.getX();
        int n2 = layoutInfo.getY();
        int n3 = layoutInfo.getWidth();
        int n4 = layoutInfo.getHeight();
        graphics.setColor(this.gridColor);
        int n5 = 0;
        while (n5 < layoutInfo.columnOrigins.length) {
            graphics.fillRect(layoutInfo.columnOrigins[n5], n2, 1, n4);
            ++n5;
        }
        n5 = 0;
        while (n5 < layoutInfo.rowOrigins.length) {
            graphics.fillRect(n, layoutInfo.rowOrigins[n5], n3, 1);
            ++n5;
        }
        if (this.paintDiagonals) {
            graphics.drawLine(n, n2, n + n3, n2 + n4);
            graphics.drawLine(n, n2 + n4, n + n3, n2);
        }
    }
}

