/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class DefaultFormatFactory
implements FormatFactory {
    public static final String STANDARD_DATE_FORMAT_DEFAULT = "default";
    public static final String STANDARD_DATE_FORMAT_SHORT = "short";
    public static final String STANDARD_DATE_FORMAT_MEDIUM = "medium";
    public static final String STANDARD_DATE_FORMAT_LONG = "long";
    public static final String STANDARD_DATE_FORMAT_FULL = "full";
    public static final String STANDARD_DATE_FORMAT_HIDE = "hide";
    public static final String STANDARD_DATE_FORMAT_SEPARATOR = ",";

    public DateFormat createDateFormat(String string, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat;
        int n;
        String string2;
        int[] nArray = null;
        int[] nArray2 = null;
        if (string != null && string.trim().length() > 0 && (nArray = DefaultFormatFactory.getDateStyle(string2 = (n = string.indexOf(STANDARD_DATE_FORMAT_SEPARATOR)) < 0 ? string : string.substring(0, n))) != null) {
            if (n >= 0) {
                String string3 = string.substring(n + STANDARD_DATE_FORMAT_SEPARATOR.length());
                nArray2 = DefaultFormatFactory.getDateStyle(string3);
            } else {
                nArray2 = nArray;
            }
        }
        if (nArray != null && nArray2 != null) {
            dateFormat = DefaultFormatFactory.getDateFormat(nArray, nArray2, locale);
        } else {
            dateFormat = locale == null ? DateFormat.getDateTimeInstance(3, 3) : DateFormat.getDateTimeInstance(3, 3, locale);
            if (string != null && string.trim().length() > 0 && dateFormat instanceof SimpleDateFormat) {
                ((SimpleDateFormat)dateFormat).applyPattern(string);
            }
        }
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    protected static int[] getDateStyle(String string) {
        if (string.equalsIgnoreCase(STANDARD_DATE_FORMAT_DEFAULT)) {
            return new int[]{2};
        }
        if (string.equalsIgnoreCase(STANDARD_DATE_FORMAT_SHORT)) {
            return new int[]{3};
        }
        if (string.equalsIgnoreCase(STANDARD_DATE_FORMAT_MEDIUM)) {
            return new int[]{2};
        }
        if (string.equalsIgnoreCase(STANDARD_DATE_FORMAT_LONG)) {
            return new int[]{1};
        }
        if (string.equalsIgnoreCase(STANDARD_DATE_FORMAT_FULL)) {
            return new int[1];
        }
        if (string.equalsIgnoreCase(STANDARD_DATE_FORMAT_HIDE)) {
            return new int[0];
        }
        return null;
    }

    protected static DateFormat getDateFormat(int[] nArray, int[] nArray2, Locale locale) {
        if (nArray.length == 0) {
            if (nArray2.length == 0) {
                return new SimpleDateFormat("");
            }
            return locale == null ? DateFormat.getTimeInstance(nArray2[0]) : DateFormat.getTimeInstance(nArray2[0], locale);
        }
        if (nArray2.length == 0) {
            return locale == null ? DateFormat.getDateInstance(nArray[0]) : DateFormat.getDateInstance(nArray[0], locale);
        }
        return locale == null ? DateFormat.getDateTimeInstance(nArray[0], nArray2[0]) : DateFormat.getDateTimeInstance(nArray[0], nArray2[0], locale);
    }

    public NumberFormat createNumberFormat(String string, Locale locale) {
        NumberFormat numberFormat = null;
        if (string != null && string.trim().length() > 0 && (numberFormat = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale)) instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern(string);
        }
        return numberFormat;
    }

    public static FormatFactory createFormatFactory(String string) {
        FormatFactory formatFactory = null;
        if (string != null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(string);
                formatFactory = (FormatFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException("Error loading format factory class : " + string, classNotFoundException);
            }
            catch (Exception exception) {
                throw new JRRuntimeException("Error creating format factory instance : " + string, exception);
            }
        } else {
            formatFactory = new DefaultFormatFactory();
        }
        return formatFactory;
    }
}

