/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal {
    char[] source;
    int lineNumber;

    public StringLiteral(char[] cArray, int n, int n2, int n3) {
        this(n, n2);
        this.source = cArray;
        this.lineNumber = n3 - 1;
    }

    public StringLiteral(int n, int n2) {
        super(n, n2);
    }

    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(CharLiteral charLiteral) {
        return new ExtendedStringLiteral(this, charLiteral);
    }

    public ExtendedStringLiteral extendWith(StringLiteral stringLiteral) {
        return new ExtendedStringLiteral(this, stringLiteral);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral stringLiteral) {
        return new StringLiteralConcatenation(this, stringLiteral);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return blockScope.getJavaLangString();
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        int n2 = 0;
        while (n2 < this.source.length) {
            switch (this.source[n2]) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(this.source[n2]);
                }
            }
            ++n2;
        }
        stringBuffer.append('\"');
        return stringBuffer;
    }

    public char[] source() {
        return this.source;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

