/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class PlasticIconFactory {
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuArrowIcon;
    private static Icon expandedTreeIcon;
    private static Icon collapsedTreeIcon;
    private static Icon comboBoxButtonIcon;

    private PlasticIconFactory() {
    }

    private static void drawCheck(Graphics graphics, int n, int n2) {
        graphics.translate(n, n2);
        graphics.drawLine(3, 5, 3, 5);
        graphics.fillRect(3, 6, 2, 2);
        graphics.drawLine(4, 8, 9, 3);
        graphics.drawLine(5, 8, 9, 4);
        graphics.drawLine(5, 9, 9, 5);
        graphics.translate(-n, -n2);
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    static Icon getExpandedTreeIcon() {
        if (expandedTreeIcon == null) {
            expandedTreeIcon = new ExpandedTreeIcon(null, null);
        }
        return expandedTreeIcon;
    }

    static Icon getCollapsedTreeIcon() {
        if (collapsedTreeIcon == null) {
            collapsedTreeIcon = new CollapsedTreeIcon();
        }
        return collapsedTreeIcon;
    }

    static Icon getComboBoxButtonIcon() {
        if (comboBoxButtonIcon == null) {
            comboBoxButtonIcon = new ComboBoxButtonIcon();
        }
        return comboBoxButtonIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (buttonModel.isEnabled()) {
                if (jCheckBox.isBorderPaintedFlat()) {
                    graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(n, n2, 11, 11);
                    graphics.setColor(PlasticLookAndFeel.getControlHighlight());
                    graphics.fillRect(n + 1, n2 + 1, 10, 10);
                } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n, n2, 12, 12);
                    PlasticUtils.drawPressed3DBorder(graphics, n, n2, 13, 13);
                } else {
                    PlasticUtils.drawFlush3DBorder(graphics, n, n2, 13, 13);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, 11, 11);
            }
            if (buttonModel.isSelected()) {
                PlasticIconFactory.drawCheck(graphics, n, n2);
            }
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            if (jMenuItem.isSelected()) {
                PlasticIconFactory.drawCheck(graphics, n, n2 + 1);
            }
        }
    }

    private static class CollapsedTreeIcon
    extends ExpandedTreeIcon {
        private CollapsedTreeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2);
            graphics.drawLine(n + 4, n2 + 2, n + 4, n2 + 6);
        }
    }

    private static class ComboBoxButtonIcon
    implements Icon,
    Serializable {
        private ComboBoxButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JComponent jComponent = (JComponent)component;
            int n3 = this.getIconWidth();
            graphics.translate(n, n2);
            graphics.setColor(jComponent.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(1, 1, 1 + (n3 - 3), 1);
            graphics.drawLine(2, 2, 2 + (n3 - 5), 2);
            graphics.drawLine(3, 3, 3 + (n3 - 7), 3);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    private static class ExpandedTreeIcon
    implements Icon,
    Serializable {
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        private ExpandedTreeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n, n2, 8, 8);
            graphics.setColor(Color.GRAY);
            graphics.drawRect(n, n2, 8, 8);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n + 2, n2 + 4, n + 6, n2 + 4);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }

        /* synthetic */ ExpandedTreeIcon(ExpandedTreeIcon expandedTreeIcon, ExpandedTreeIcon expandedTreeIcon2) {
            this();
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int WIDTH = 4;
        private static final int HEIGHT = 8;

        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            graphics.translate(n, n2);
            if (PlasticUtils.isLeftToRight(jMenuItem)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private RadioButtonMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            if (jMenuItem.isSelected()) {
                this.drawDot(graphics, n, n2);
            }
        }

        private void drawDot(Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.drawLine(5, 4, 8, 4);
            graphics.fillRect(4, 5, 6, 4);
            graphics.drawLine(5, 9, 8, 9);
            graphics.translate(-n, -n2);
        }
    }
}

