/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class LongLiteral
extends NumberLiteral {
    long value;
    static final Constant FORMAT_ERROR = DoubleConstant.fromValue(Double.POSITIVE_INFINITY);

    public LongLiteral(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public LongLiteral(char[] cArray, int n, int n2, long l) {
        this(cArray, n, n2);
        this.value = l;
    }

    public void computeConstant() {
        long l;
        int n = this.source.length - 1;
        if (this.source[0] == '0') {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == 1) {
                this.constant = LongConstant.fromValue(0L);
                return;
            }
            if (this.source[1] == 'x' || this.source[1] == 'X') {
                n5 = 4;
                n4 = 2;
                n3 = 16;
            } else {
                n5 = 3;
                n4 = 1;
                n3 = 8;
            }
            int n6 = 0;
            while (this.source[n4] == '0') {
                if (++n4 != n) continue;
                this.value = 0L;
                this.constant = LongConstant.fromValue(0L);
                return;
            }
            if ((n2 = ScannerHelper.digit(this.source[n4++], n3)) < 0) {
                this.constant = FORMAT_ERROR;
                return;
            }
            n6 = n2 >= 8 ? 4 : (n2 >= 4 ? 3 : (n2 >= 2 ? 2 : 1));
            l = n2;
            while (n4 < n) {
                if ((n2 = ScannerHelper.digit(this.source[n4++], n3)) < 0) {
                    this.constant = FORMAT_ERROR;
                    return;
                }
                if ((n6 += n5) > 64) {
                    return;
                }
                l = l << n5 | (long)n2;
            }
        } else {
            long l2 = 0L;
            l = 0L;
            int n7 = 0;
            while (n7 < n) {
                int n8 = ScannerHelper.digit(this.source[n7], 10);
                if (n8 < 0) {
                    return;
                }
                l2 = l;
                if (l > 0xCCCCCCCCCCCCCCCL) {
                    return;
                }
                if ((l *= 10L) + (long)n8 > Long.MAX_VALUE) {
                    return;
                }
                if (l2 > (l += (long)n8)) {
                    return;
                }
                ++n7;
            }
        }
        this.value = l;
        this.constant = LongConstant.fromValue(this.value);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.LONG;
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.source.length == 20 && this.source[0] == '9' && this.source[1] == '2' && this.source[2] == '2' && this.source[3] == '3' && this.source[4] == '3' && this.source[5] == '7' && this.source[6] == '2' && this.source[7] == '0' && this.source[8] == '3' && this.source[9] == '6' && this.source[10] == '8' && this.source[11] == '5' && this.source[12] == '4' && this.source[13] == '7' && this.source[14] == '7' && this.source[15] == '5' && this.source[16] == '8' && this.source[17] == '0' && this.source[18] == '8' && (this.bits & 0x1FE00000) >> 21 == 0;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = super.resolveType(blockScope);
        if (this.constant == FORMAT_ERROR) {
            this.constant = Constant.NotAConstant;
            blockScope.problemReporter().constantOutOfFormat(this);
            this.resolvedType = null;
            return null;
        }
        return typeBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

