/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultHighLowDataset;

public class JRFillHighLowDataset
extends JRFillChartDataset
implements JRHighLowDataset {
    private String series = null;
    private List elements = new ArrayList();
    private Date date = null;
    private Number high = null;
    private Number low = null;
    private Number open = null;
    private Number close = null;
    private Number volume = null;
    private JRPrintHyperlink itemHyperlink;
    private List itemHyperlinks;

    public JRFillHighLowDataset(JRHighLowDataset jRHighLowDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRHighLowDataset, jRFillObjectFactory);
    }

    protected void customInitialize() {
        this.elements = new ArrayList();
        this.itemHyperlinks = new ArrayList();
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        this.series = (String)jRCalculator.evaluate(this.getSeriesExpression());
        this.date = (Date)jRCalculator.evaluate(this.getDateExpression());
        this.high = (Number)jRCalculator.evaluate(this.getHighExpression());
        this.low = (Number)jRCalculator.evaluate(this.getLowExpression());
        this.open = (Number)jRCalculator.evaluate(this.getOpenExpression());
        this.close = (Number)jRCalculator.evaluate(this.getCloseExpression());
        this.volume = (Number)jRCalculator.evaluate(this.getVolumeExpression());
        if (this.hasItemHyperlink()) {
            this.evaluateSectionHyperlink(jRCalculator);
        }
    }

    protected void evaluateSectionHyperlink(JRCalculator jRCalculator) throws JRExpressionEvalException {
        try {
            this.itemHyperlink = JRFillHyperlinkHelper.evaluateHyperlink(this.getItemHyperlink(), jRCalculator, (byte)3);
        }
        catch (JRExpressionEvalException jRExpressionEvalException) {
            throw jRExpressionEvalException;
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    protected void customIncrement() {
        this.elements.add(new HighLowElement(this.date, this.high, this.low, this.open, this.close, this.volume));
        if (this.hasItemHyperlink()) {
            this.itemHyperlinks.add(this.itemHyperlink);
        }
    }

    public Dataset getCustomDataset() {
        int n = this.elements.size();
        Date[] dateArray = new Date[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        int n2 = 0;
        while (n2 < this.elements.size()) {
            HighLowElement highLowElement = (HighLowElement)this.elements.get(n2);
            dateArray[n2] = new Date(highLowElement.getDate().getTime());
            dArray[n2] = highLowElement.getHigh().doubleValue();
            dArray2[n2] = highLowElement.getLow().doubleValue();
            dArray3[n2] = highLowElement.getOpen().doubleValue();
            dArray4[n2] = highLowElement.getClose().doubleValue();
            dArray5[n2] = highLowElement.getVolume().doubleValue();
            ++n2;
        }
        return new DefaultHighLowDataset((Comparable)((Object)this.series), dateArray, dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public JRExpression getSeriesExpression() {
        return ((JRHighLowDataset)this.parent).getSeriesExpression();
    }

    public JRExpression getDateExpression() {
        return ((JRHighLowDataset)this.parent).getDateExpression();
    }

    public JRExpression getHighExpression() {
        return ((JRHighLowDataset)this.parent).getHighExpression();
    }

    public JRExpression getLowExpression() {
        return ((JRHighLowDataset)this.parent).getLowExpression();
    }

    public JRExpression getOpenExpression() {
        return ((JRHighLowDataset)this.parent).getOpenExpression();
    }

    public JRExpression getCloseExpression() {
        return ((JRHighLowDataset)this.parent).getCloseExpression();
    }

    public JRExpression getVolumeExpression() {
        return ((JRHighLowDataset)this.parent).getVolumeExpression();
    }

    public byte getDatasetType() {
        return 7;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public JRHyperlink getItemHyperlink() {
        return ((JRHighLowDataset)this.parent).getItemHyperlink();
    }

    public boolean hasItemHyperlink() {
        return this.getItemHyperlink() != null;
    }

    public List getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }

    private static class HighLowElement {
        Date date;
        Number high;
        Number low;
        Number open;
        Number close;
        Number volume;

        public HighLowElement(Date date, Number number, Number number2, Number number3, Number number4, Number number5) {
            this.date = date;
            this.high = number;
            this.low = number2;
            this.open = number3;
            this.close = number4;
            this.volume = number5;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Number getHigh() {
            return this.high;
        }

        public void setHigh(Number number) {
            this.high = number;
        }

        public Number getLow() {
            return this.low;
        }

        public void setLow(Number number) {
            this.low = number;
        }

        public Number getOpen() {
            return this.open;
        }

        public void setOpen(Number number) {
            this.open = number;
        }

        public Number getClose() {
            return this.close;
        }

        public void setClose(Number number) {
            this.close = number;
        }

        public Number getVolume() {
            return this.volume;
        }

        public void setVolume(Number number) {
            this.volume = number;
        }
    }
}

