/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;

public class JRClonePool {
    private final JRCloneable original;
    private final LinkedList availableClones;
    private final boolean trackLockedClones;
    private final Set lockedClones;

    public JRClonePool(JRCloneable jRCloneable, boolean bl, boolean bl2) {
        this.original = jRCloneable;
        this.availableClones = new LinkedList();
        this.trackLockedClones = bl;
        this.lockedClones = bl ? new HashSet() : null;
        if (bl2) {
            this.availableClones.add(jRCloneable);
        }
    }

    public Object getClone() {
        JRCloneable jRCloneable;
        if (this.availableClones.isEmpty()) {
            JRFillCloneFactory jRFillCloneFactory = new JRFillCloneFactory();
            jRCloneable = this.original.createClone(jRFillCloneFactory);
        } else {
            jRCloneable = (JRCloneable)this.availableClones.removeFirst();
        }
        if (this.trackLockedClones) {
            this.lockedClones.add(jRCloneable);
        }
        return jRCloneable;
    }

    public void releaseClone(Object object) {
        if (this.trackLockedClones && !this.lockedClones.remove(object)) {
            throw new JRRuntimeException("Cannot release clone.");
        }
        this.availableClones.addLast(object);
    }
}

