/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PdfImage
extends PdfStream {
    static final int TRANSFERSIZE = 4096;
    protected PdfName name;

    /*
     * Unable to fully structure code
     */
    public PdfImage(Image var1_1, String var2_2, PdfIndirectReference var3_3) throws BadPdfFormatException {
        block48: {
            block49: {
                super();
                this.name = null;
                this.name = new PdfName(var2_2);
                this.put(PdfName.TYPE, PdfName.XOBJECT);
                this.put(PdfName.SUBTYPE, PdfName.IMAGE);
                this.put(PdfName.WIDTH, new PdfNumber(var1_1.width()));
                this.put(PdfName.HEIGHT, new PdfNumber(var1_1.height()));
                if (var1_1.getLayer() != null) {
                    this.put(PdfName.OC, var1_1.getLayer().getRef());
                }
                if (var1_1.isMask() && (var1_1.bpc() == 1 || var1_1.bpc() > 255)) {
                    this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
                }
                if (var3_3 != null) {
                    if (var1_1.isSmask()) {
                        this.put(PdfName.SMASK, var3_3);
                    } else {
                        this.put(PdfName.MASK, var3_3);
                    }
                }
                if (var1_1.isMask() && var1_1.isInvertMask()) {
                    this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                }
                if (var1_1.isInterpolation()) {
                    this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
                }
                var4_4 = null;
                if (!var1_1.isImgRaw()) break block48;
                var5_5 = var1_1.colorspace();
                var6_8 = var1_1.getTransparency();
                if (var6_8 != null && !var1_1.isMask() && var3_3 == null) {
                    var7_9 = "[";
                    var8_11 = 0;
                    while (var8_11 < var6_8.length) {
                        var7_9 = String.valueOf(var7_9) + var6_8[var8_11] + " ";
                        ++var8_11;
                    }
                    var7_9 = String.valueOf(var7_9) + "]";
                    this.put(PdfName.MASK, new PdfLiteral(var7_9));
                }
                this.bytes = var1_1.rawData();
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                var7_10 = var1_1.bpc();
                if (var7_10 > 255) {
                    if (!var1_1.isMask()) {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                    this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                    var8_11 = var7_10 - 257;
                    var9_13 = new PdfDictionary();
                    if (var8_11 != 0) {
                        var9_13.put(PdfName.K, new PdfNumber(var8_11));
                    }
                    if ((var5_5 & 1) != 0) {
                        var9_13.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                    }
                    if ((var5_5 & 2) != 0) {
                        var9_13.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                    }
                    if ((var5_5 & 4) != 0) {
                        var9_13.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                    }
                    if ((var5_5 & 8) != 0) {
                        var9_13.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                    }
                    var9_13.put(PdfName.COLUMNS, new PdfNumber(var1_1.width()));
                    var9_13.put(PdfName.ROWS, new PdfNumber(var1_1.height()));
                    this.put(PdfName.DECODEPARMS, var9_13);
                    break block49;
                }
                switch (var5_5) {
                    case 1: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                        if (!var1_1.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                        break;
                    }
                    case 3: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                        if (!var1_1.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0]"));
                        break;
                    }
                    default: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                        if (!var1_1.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                    }
                }
                if ((var8_12 = var1_1.getAdditional()) != null) {
                    this.putAll(var8_12);
                }
                if (var1_1.isMask() && (var1_1.bpc() == 1 || var1_1.bpc() > 8)) {
                    this.remove(PdfName.COLORSPACE);
                }
                this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var1_1.bpc()));
                if (var1_1.isDeflated()) {
                    this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                    break block49;
                }
                this.flateCompress();
            }
lbl84:
            // 2 sources

            while (true) {
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Exception v0) {}
                }
                return;
            }
        }
        try {
            try {
                if (var1_1.rawData() == null) {
                    var4_4 = var1_1.url().openStream();
                    var5_6 = var1_1.url().toString();
                } else {
                    var4_4 = new ByteArrayInputStream(var1_1.rawData());
                    var5_6 = "Byte array";
                }
                switch (var1_1.type()) {
                    case 32: {
                        this.put(PdfName.FILTER, PdfName.DCTDECODE);
                        switch (var1_1.colorspace()) {
                            case 1: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                break;
                            }
                            case 3: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                break;
                            }
                            default: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                if (!var1_1.isInverted()) break;
                                this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                            }
                        }
                        this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                        if (var1_1.rawData() != null) {
                            this.bytes = var1_1.rawData();
                            this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                            ** continue;
                        }
                        this.streamBytes = new ByteArrayOutputStream();
                        PdfImage.transferBytes(var4_4, this.streamBytes, -1);
                        break;
                    }
                    default: {
                        throw new BadPdfFormatException(String.valueOf(var5_6) + " is an unknown Image format.");
                    }
                }
                this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            }
            catch (IOException var5_7) {
                throw new BadPdfFormatException(var5_7.getMessage());
            }
        }
        catch (Throwable var10_14) {
            if (var4_4 != null) {
                try {
                    var4_4.close();
                }
                catch (Exception v1) {}
            }
            throw var10_14;
        }
        if (var4_4 != null) {
            try {
                var4_4.close();
            }
            catch (Exception v2) {}
        }
    }

    public PdfName name() {
        return this.name;
    }

    static void transferBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4096];
        if (n < 0) {
            n = 0x7FFFFFF;
        }
        while (n != 0) {
            int n2 = inputStream.read(byArray, 0, Math.min(n, 4096));
            if (n2 < 0) {
                return;
            }
            outputStream.write(byArray, 0, n2);
            n -= n2;
        }
    }

    protected void importAll(PdfImage pdfImage) {
        this.name = pdfImage.name;
        this.compressed = pdfImage.compressed;
        this.streamBytes = pdfImage.streamBytes;
        this.bytes = pdfImage.bytes;
        this.hashMap = pdfImage.hashMap;
    }
}

