/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jfree.chart.plot.ColorPalette;

public class PaletteSample
extends JComponent
implements ListCellRenderer {
    private ColorPalette palette;
    private Dimension preferredSize;

    public PaletteSample(ColorPalette colorPalette) {
        this.palette = colorPalette;
        this.preferredSize = new Dimension(80, 18);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof PaletteSample) {
            PaletteSample paletteSample = (PaletteSample)object;
            this.setPalette(paletteSample.getPalette());
        }
        return this;
    }

    public ColorPalette getPalette() {
        return this.palette;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        double d = dimension.getWidth() - (double)insets.left - (double)insets.right;
        double d2 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d3 = insets.top;
        double d4 = d3 + d2;
        double d5 = insets.left;
        Line2D.Double double_ = new Line2D.Double();
        int n = 0;
        while (d5 <= (double)insets.left + d) {
            ((Line2D)double_).setLine(d5, d3, d5, d4);
            graphics2D.setPaint(this.palette.getColor(++n));
            graphics2D.draw(double_);
            d5 += 1.0;
        }
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
        this.repaint();
    }
}

