/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.List;
import serpro.ppgd.irpf.rendavariavel.ColecaoItemImpostoPagar;
import serpro.ppgd.irpf.rendavariavel.ItemImpostoPagar;
import serpro.ppgd.irpf.rendavariavel.ObservadorHabDesabIrRetidoFonteLei11033;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.irpf.rendavariavel.ValidadorImpostoRetidoLei11033;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class GanhosLiquidosOuPerdas
extends ObjetoNegocio {
    public static final String PROP_IR_FONTE_DAYTRADE = "IRFONTEDAYTRADE";
    public static final String PROP_IMP_RETIDO_LEI_11033 = "IR LEI 11033";
    public static final String PROP_IMP_PAGO = "IMP PAGO";
    public static final String MES = "M\u00eas";
    private Operacoes operacoesComuns = new Operacoes("15");
    private Operacoes operacoesDayTrade = new Operacoes("20");
    private ColecaoItemImpostoPagar colecaoItemImpostoPagar = new ColecaoItemImpostoPagar(ItemImpostoPagar.class.getName());
    private Valor totalImpostoDevido = new Valor(this, "");
    private Valor irFonteDayTradeMesAtual = new Valor(this, "IRFONTEDAYTRADE");
    private Valor irFonteDayTradeMesesAnteriores = new Valor(this, "");
    private Valor irFonteDayTradeAcompensar = new Valor(this, "");
    private Valor impostoApagar = new Valor(this, "");
    private Valor impostoPago = new Valor(this, "IMP PAGO");
    private Valor impostoRetidoFonteLei11033 = new Valor(this, "IR LEI 11033");
    public static final String ALIQUOTA_DAYTRADE = "20";
    public static final String ALIQUOTA_COMUM = "15";

    public GanhosLiquidosOuPerdas() {
        this.getOperacoesComuns().getAliquotaDoImposto().setConteudo("15%");
        this.getOperacoesDayTrade().getAliquotaDoImposto().setConteudo("20%");
        this.getOperacoesComuns().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesDayTrade().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesComuns().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesDayTrade().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesComuns().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesDayTrade().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesComuns().getAliquotaDoImposto().setHabilitado(false);
        this.getOperacoesDayTrade().getAliquotaDoImposto().setHabilitado(false);
        this.getOperacoesComuns().getImpostoDevido().setReadOnly(true);
        this.getOperacoesDayTrade().getImpostoDevido().setReadOnly(true);
        this.getOperacoesComuns().getResultadoNegativoMesAnterior().setHabilitado(false);
        this.getOperacoesDayTrade().getResultadoNegativoMesAnterior().setHabilitado(false);
        this.getTotalImpostoDevido().setReadOnly(true);
        this.getIrFonteDayTradeMesesAnteriores().setReadOnly(true);
        this.getIrFonteDayTradeAcompensar().setReadOnly(true);
        this.getImpostoApagar().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033().addValidador(new ValidadorImpostoRetidoLei11033(this));
        ObservadorHabDesabIrRetidoFonteLei11033 observadorHabDesabIrRetidoFonteLei11033 = new ObservadorHabDesabIrRetidoFonteLei11033(this);
        this.getTotalImpostoDevido().addObservador(observadorHabDesabIrRetidoFonteLei11033);
        this.getIrFonteDayTradeMesAtual().addObservador(observadorHabDesabIrRetidoFonteLei11033);
        this.getIrFonteDayTradeMesesAnteriores().addObservador(observadorHabDesabIrRetidoFonteLei11033);
        this.getOperacoesComuns().getImpostoDevido().addObservador(this);
        this.getOperacoesDayTrade().getImpostoDevido().addObservador(this);
        this.getIrFonteDayTradeMesAtual().addObservador(this);
        this.getIrFonteDayTradeMesesAnteriores().addObservador(this);
        this.getImpostoRetidoFonteLei11033().addObservador(this);
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.totalImpostoDevido.setConteudo(this.getOperacoesComuns().getImpostoDevido().operacao('+', this.getOperacoesDayTrade().getImpostoDevido()));
        Valor valor = new Valor();
        valor.append('+', this.getIrFonteDayTradeMesAtual());
        valor.append('+', this.getIrFonteDayTradeMesesAnteriores());
        if (valor.comparacao(">", this.getTotalImpostoDevido())) {
            Valor valor2 = new Valor();
            valor2.append('+', valor);
            valor2.append('-', this.getTotalImpostoDevido());
            this.getIrFonteDayTradeAcompensar().setConteudo(valor2);
            this.getImpostoApagar().clear();
        } else {
            this.getIrFonteDayTradeAcompensar().clear();
            Valor valor3 = new Valor();
            valor3.append('+', this.getTotalImpostoDevido());
            valor3.append('-', valor);
            valor3.append('-', this.getImpostoRetidoFonteLei11033());
            this.getImpostoApagar().setConteudo(valor3);
        }
    }

    public void adicionarObservadorCalculosRendaVariavel(Observador observador) {
        this.operacoesComuns.getBaseCalculoImposto().addObservador(observador);
        this.operacoesDayTrade.getBaseCalculoImposto().addObservador(observador);
        this.irFonteDayTradeMesAtual.addObservador(observador);
        this.impostoPago.addObservador(observador);
        this.impostoRetidoFonteLei11033.addObservador(observador);
    }

    public Operacoes getOperacoesComuns() {
        return this.operacoesComuns;
    }

    public Operacoes getOperacoesDayTrade() {
        return this.operacoesDayTrade;
    }

    public Valor getImpostoApagar() {
        return this.impostoApagar;
    }

    public Valor getImpostoPago() {
        return this.impostoPago;
    }

    public Valor getIrFonteDayTradeAcompensar() {
        return this.irFonteDayTradeAcompensar;
    }

    public Valor getIrFonteDayTradeMesAtual() {
        return this.irFonteDayTradeMesAtual;
    }

    public Valor getIrFonteDayTradeMesesAnteriores() {
        return this.irFonteDayTradeMesesAnteriores;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    public ColecaoItemImpostoPagar getColecaoItemImpostoPagar() {
        return this.colecaoItemImpostoPagar;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarCamposInformacao();
        return list;
    }

    public boolean estaVazio() {
        boolean bl = this.operacoesComuns.isVazio();
        bl = bl && this.operacoesDayTrade.isVazio();
        bl = bl && this.irFonteDayTradeMesAtual.isVazio();
        bl = bl && this.impostoPago.isVazio();
        bl = bl && this.impostoRetidoFonteLei11033.isVazio();
        bl = bl && this.operacoesComuns.getResultadoLiquidoMes().isVazio();
        bl = bl && this.operacoesComuns.getResultadoNegativoMesAnterior().isVazio();
        bl = bl && this.operacoesDayTrade.getResultadoLiquidoMes().isVazio();
        bl = bl && this.operacoesDayTrade.getResultadoNegativoMesAnterior().isVazio();
        return bl;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public void clear() {
        super.clear();
        this.operacoesComuns.clear();
        this.operacoesDayTrade.clear();
    }
}

