/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao {
    private transient DeclaracaoIRPF objDecl;
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private Valor totalDeducoesInstrucao = new Valor(this, "");
    private Valor totalContribuicaoFAPI = new Valor(this, "");
    private Valor totalDespesasMedicas = new Valor(this, "");
    private Valor totalPensao = new Valor(this, "");
    private Valor totalPensaoCartoral = new Valor(this, "");
    private Valor totalDeducaoIncentivo = new Valor(this, "");
    private Valor totalContribEmpregadoDomestico = new Valor(this, "");

    public Pagamentos(DeclaracaoIRPF declaracaoIRPF) {
        super(Pagamento.class.getName());
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.objDecl = declaracaoIRPF;
        this.setFicha("Pagamentos e Doa\u00e7\u00f5es Efetuados");
    }

    public void objetoInserido(Object object) {
        ((ObjetoNegocio)object).setFicha(this.getFicha());
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        return new Pagamento(this.objDecl);
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoFAPI() {
        return this.totalContribuicaoFAPI;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("30")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public String recuperarCpfMaiorEmpregadaDomestica() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("50") || pagamento.getNiBeneficiario().asString().trim().length() < 11) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public NI recuperarNIMaiorDespMedicas() {
        Object object;
        Object object2;
        class BeneficiarioMedico {
            public Valor total;
            public NI ni;
            final /* synthetic */ Pagamentos this$0;

            BeneficiarioMedico(Pagamentos pagamentos) {
                this.this$0 = pagamentos;
            }
        }
        Hashtable<String, BeneficiarioMedico> hashtable = new Hashtable<String, BeneficiarioMedico>();
        List list = this.recuperarLista();
        int n = 0;
        while (n < this.recuperarLista().size()) {
            object2 = (Pagamento)list.get(n);
            if (((Pagamento)object2).getCodigo().toString().equals("10") || ((Pagamento)object2).getCodigo().toString().equals("20") || ((Pagamento)object2).getCodigo().toString().equals("26")) {
                BeneficiarioMedico beneficiarioMedico;
                object = new Valor();
                if (((Pagamento)object2).getValorPago().comparacao(">=", ((Pagamento)object2).getParcelaNaoDedutivel())) {
                    ((Valor)object).append('+', ((Pagamento)object2).getValorPago());
                    ((Valor)object).append('-', ((Pagamento)object2).getParcelaNaoDedutivel());
                }
                if ((beneficiarioMedico = (BeneficiarioMedico)hashtable.get(((Pagamento)object2).getNiBeneficiario())) == null) {
                    beneficiarioMedico = new BeneficiarioMedico(this);
                    beneficiarioMedico.total = object;
                    beneficiarioMedico.ni = ((Pagamento)object2).getNiBeneficiario();
                    hashtable.put(beneficiarioMedico.ni.asString(), beneficiarioMedico);
                } else {
                    beneficiarioMedico.total.append('+', (Valor)object);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.values().iterator();
        object2 = null;
        if (iterator.hasNext()) {
            object2 = (BeneficiarioMedico)iterator.next();
            while (iterator.hasNext()) {
                object = (BeneficiarioMedico)iterator.next();
                if (!((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object2).total)) continue;
                object2 = object;
            }
        }
        if (object2 == null) {
            return new NI(this, "");
        }
        return ((BeneficiarioMedico)object2).ni;
    }

    public NI recuperarNISegundoMaiorDespMedicas() {
        class BeneficiarioMedico {
            public Valor total;
            public NI ni;
            final /* synthetic */ Pagamentos this$0;

            BeneficiarioMedico(Pagamentos pagamentos) {
                this.this$0 = pagamentos;
            }
        }
        BeneficiarioMedico beneficiarioMedico;
        Object object;
        Object object2;
        Hashtable<String, BeneficiarioMedico> hashtable = new Hashtable<String, BeneficiarioMedico>();
        List list = this.recuperarLista();
        int n = 0;
        while (n < this.recuperarLista().size()) {
            object2 = (Pagamento)list.get(n);
            if (((Pagamento)object2).getCodigo().toString().equals("10") || ((Pagamento)object2).getCodigo().toString().equals("20") || ((Pagamento)object2).getCodigo().toString().equals("26")) {
                object = new Valor();
                if (((Pagamento)object2).getValorPago().comparacao(">=", ((Pagamento)object2).getParcelaNaoDedutivel())) {
                    ((Valor)object).append('+', ((Pagamento)object2).getValorPago());
                    ((Valor)object).append('-', ((Pagamento)object2).getParcelaNaoDedutivel());
                }
                if ((beneficiarioMedico = (BeneficiarioMedico)hashtable.get(((Pagamento)object2).getNiBeneficiario())) == null) {
                    beneficiarioMedico = new BeneficiarioMedico(this);
                    beneficiarioMedico.total = object;
                    beneficiarioMedico.ni = ((Pagamento)object2).getNiBeneficiario();
                    hashtable.put(beneficiarioMedico.ni.asString(), beneficiarioMedico);
                } else {
                    beneficiarioMedico.total.append('+', (Valor)object);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.values().iterator();
        object2 = null;
        object = null;
        if (iterator.hasNext()) {
            object2 = (BeneficiarioMedico)iterator.next();
            while (iterator.hasNext()) {
                beneficiarioMedico = (BeneficiarioMedico)iterator.next();
                if (beneficiarioMedico.total.comparacao(">", ((BeneficiarioMedico)object2).total)) {
                    object = object2;
                    object2 = beneficiarioMedico;
                    continue;
                }
                if (object != null && !beneficiarioMedico.total.comparacao(">", ((BeneficiarioMedico)object).total)) continue;
                object = beneficiarioMedico;
            }
        }
        if (object == null) {
            return new NI(this, "");
        }
        return ((BeneficiarioMedico)object).ni;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n = 0;
        if (!hashSet.isEmpty()) {
            n = hashSet.size();
        }
        return n;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n = 0;
        if (!hashSet.isEmpty()) {
            n = hashSet.size();
        }
        return n;
    }

    public void setTotalContribEmpregadoDomestico(Valor valor) {
        this.totalContribEmpregadoDomestico = valor;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }
}

