/* ObservadorCodigoPagamento - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.pagamentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class ObservadorCodigoPagamento extends Observador
{
  private DeclaracaoIRPF declaracaoIRPF = null;
  
  public ObservadorCodigoPagamento (DeclaracaoIRPF dec)
  {
    declaracaoIRPF = dec;
  }
  
  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    if (nomePropriedade != null)
      {
	if (nomePropriedade.equals ("ObjetoInserido"))
	  {
	    Pagamento pagamento = (Pagamento) valorNovo;
	    pagamento.getCodigo ().addObservador (this);
	    String codigoPagamento = pagamento.getCodigo ().getConteudoAtual (0);
	    pagamento.getDependenteOuAlimentando ().setHabilitado (codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAODEPEND_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAODEPEND_EX) || codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAOALIMENT_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAOALIMENT_EX));
	    pagamento.getCodigo ().disparaObservadores ();
	  }
	else if (nomePropriedade.equals ("ObjetoRemovido"))
	  {
	    Pagamento pagamento = (Pagamento) valorNovo;
	    pagamento.getCodigo ().removeObservador (this);
	  }
	else if (nomePropriedade.equals ("C\u00f3digo"))
	  {
	    Pagamento pagamento = (Pagamento) ((Informacao) observado).getOwner ();
	    String codigoPagamento = pagamento.getCodigo ().getConteudoAtual (0);
	    if (codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAODEPEND_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAODEPEND_EX))
	      {
		pagamento.getDependenteOuAlimentando ().setHabilitado (true);
		pagamento.getParcelaNaoDedutivel ().setHabilitado (true);
		pagamento.getNitEmpregadoDomestico ().setHabilitado (false);
		if (valorAntigo != null && (valorAntigo.equals (Pagamento.PAGAMENTO_INSTRUCAOALIMENT_BR) || valorAntigo.equals (Pagamento.PAGAMENTO_INSTRUCAOALIMENT_EX)))
		  pagamento.getDependenteOuAlimentando ().clear ();
	      }
	    else if (codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAOALIMENT_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_INSTRUCAOALIMENT_EX))
	      {
		pagamento.getDependenteOuAlimentando ().setHabilitado (true);
		pagamento.getParcelaNaoDedutivel ().setHabilitado (true);
		pagamento.getNitEmpregadoDomestico ().setHabilitado (false);
		if (valorAntigo != null && (valorAntigo.equals (Pagamento.PAGAMENTO_INSTRUCAODEPEND_BR) || valorAntigo.equals (Pagamento.PAGAMENTO_INSTRUCAODEPEND_EX)))
		  pagamento.getDependenteOuAlimentando ().clear ();
	      }
	    else if (codigoPagamento.equals (Pagamento.PAGAMENTO_PREVIPRIVADA) || codigoPagamento.equals (Pagamento.PAGAMENTO_FAPI) || codigoPagamento.equals (Pagamento.PAGAMENTO_ESTATCRIANCA) || codigoPagamento.equals (Pagamento.PAGAMENTO_AUDIOVISUAIS) || codigoPagamento.equals (Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADVOGADOS) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADVOGADOS_TRAB) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADVOGADOS_HONORARIOS) || codigoPagamento.equals (Pagamento.PAGAMENTO_PROFLIBERAL) || codigoPagamento.equals (Pagamento.PAGAMENTO_ALUGUEIS) || codigoPagamento.equals (Pagamento.PAGAMENTO_ARRENDRURAL) || codigoPagamento.equals (Pagamento.PAGAMENTO_OUTROS))
	      {
		pagamento.getParcelaNaoDedutivel ().setHabilitado (false);
		pagamento.getParcelaNaoDedutivel ().clear ();
		if (codigoPagamento.equals (Pagamento.PAGAMENTO_CONTRIBUICAO_PATRONAL))
		  {
		    pagamento.getNitEmpregadoDomestico ().setHabilitado (true);
		    pagamento.getNiBeneficiario ().setHabilitado (false);
		  }
		else
		  {
		    pagamento.getNitEmpregadoDomestico ().setHabilitado (false);
		    pagamento.getNitEmpregadoDomestico ().clear ();
		    pagamento.getNiBeneficiario ().setHabilitado (true);
		  }
	      }
	    else
	      {
		pagamento.getDependenteOuAlimentando ().clear ();
		pagamento.getDependenteOuAlimentando ().setHabilitado (false);
		pagamento.getParcelaNaoDedutivel ().clear ();
		pagamento.getParcelaNaoDedutivel ().setHabilitado (true);
		pagamento.getNitEmpregadoDomestico ().setHabilitado (false);
		pagamento.getNitEmpregadoDomestico ().clear ();
		pagamento.getNiBeneficiario ().setHabilitado (true);
	      }
	  }
      }
  }
}
