/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNegativo;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class MesRendPF
extends ObjetoNegocio {
    public static final String VALOR_DEPENDENTE_CL = "132,05";
    public static final String VALOR_DEPENDENTE_CL_JANEIRO = "132,05";
    public static final String NOME_PESSOA_FISICA = "Pessoa F\u00edsica";
    public static final String NOME_EXTERIOR = "Exterior";
    public static final String NOME_PREV_OFICIAL = "Previd\u00eancia oficial";
    public static final String NOME_DEPENDENTES = "Dependentes";
    public static final String NOME_PENSAOALIM = "Pens\u00e3o Aliment\u00edcia";
    public static final String NOME_LIVRO_CAIXA = "Livro Caixa";
    public static final String NOME_CARNE_LEAO = "Carn\u00ea-Le\u00e3o";
    public static final String NOME_DARF_PAGO = "Darf Pago c\u00f3d. 0190";
    private Inteiro mes = new Inteiro(this, "");
    private Valor pessoaFisica = new Valor(this, "Pessoa F\u00edsica");
    private Valor exterior = new Valor(this, "Exterior");
    private Valor previdencia = new Valor(this, "Previd\u00eancia oficial");
    private Valor dependentes = new Valor(this, "Dependentes");
    private Valor pensao = new Valor(this, "Pens\u00e3o Aliment\u00edcia");
    private Valor livroCaixa = new Valor(this, "Livro Caixa");
    private Valor carneLeao = new Valor(this, "Carn\u00ea-Le\u00e3o");
    private Valor darfPago = new Valor(this, "Darf Pago c\u00f3d. 0190");

    public MesRendPF() {
        this.pessoaFisica.addValidador(new ValidadorNaoNegativo(3));
        this.exterior.addValidador(new ValidadorNaoNegativo(3));
        this.previdencia.addValidador(new ValidadorNaoNegativo(3));
        this.dependentes.addValidador(new ValidadorNaoNegativo(3));
        this.pensao.addValidador(new ValidadorNaoNegativo(3));
        this.livroCaixa.addValidador(new ValidadorNaoNegativo(3));
        this.carneLeao.addValidador(new ValidadorNaoNegativo(3));
        this.darfPago.addValidador(new ValidadorNaoNegativo(3));
    }

    public void addObservador(Observador observador) {
        this.pessoaFisica.addObservador(observador);
        this.exterior.addObservador(observador);
        this.previdencia.addObservador(observador);
        this.dependentes.addObservador(observador);
        this.pensao.addObservador(observador);
        this.livroCaixa.addObservador(observador);
        this.carneLeao.addObservador(observador);
        this.darfPago.addObservador(observador);
    }

    public Valor getCarneLeao() {
        return this.carneLeao;
    }

    public Valor getDependentes() {
        return this.dependentes;
    }

    public Valor getExterior() {
        return this.exterior;
    }

    public Valor getLivroCaixa() {
        return this.livroCaixa;
    }

    public Inteiro getMes() {
        return this.mes;
    }

    public Valor getPensao() {
        return this.pensao;
    }

    public Valor getPessoaFisica() {
        return this.pessoaFisica;
    }

    public Valor getPrevidencia() {
        return this.previdencia;
    }

    public Valor getDarfPago() {
        return this.darfPago;
    }

    public boolean isVazio() {
        return this.pessoaFisica.isVazio() && this.exterior.isVazio() && this.previdencia.isVazio() && this.dependentes.isVazio() && this.pensao.isVazio() && this.livroCaixa.isVazio() && this.carneLeao.isVazio() && this.darfPago.isVazio();
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getDependentes());
        list.add(this.getPessoaFisica());
        list.add(this.getDarfPago());
        list.add(this.getExterior());
        list.add(this.getLivroCaixa());
        list.add(this.getPensao());
        list.add(this.getPrevidencia());
        return list;
    }
}

