/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

public class JRTypeSniffer {
    public static boolean isGIF(byte[] byArray) {
        if (byArray.length < 3) {
            return false;
        }
        byte[] byArray2 = new byte[3];
        System.arraycopy(byArray, 0, byArray2, 0, 3);
        return new String(byArray2).equalsIgnoreCase("GIF");
    }

    public static boolean isJPEG(byte[] byArray) {
        if (byArray.length < 2) {
            return false;
        }
        return byArray[0] == -1 && byArray[1] == -40;
    }

    public static boolean isPNG(byte[] byArray) {
        if (byArray.length < 8) {
            return false;
        }
        return byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }

    public static boolean isTIFF(byte[] byArray) {
        if (byArray.length < 2) {
            return false;
        }
        return byArray[0] == 73 && byArray[1] == 73 || byArray[0] == 77 && byArray[1] == 77;
    }

    public static byte getImageType(byte[] byArray) {
        if (JRTypeSniffer.isGIF(byArray)) {
            return 1;
        }
        if (JRTypeSniffer.isJPEG(byArray)) {
            return 2;
        }
        if (JRTypeSniffer.isPNG(byArray)) {
            return 3;
        }
        if (JRTypeSniffer.isTIFF(byArray)) {
            return 4;
        }
        return 0;
    }

    public static String getImageMimeType(byte by) {
        String string = null;
        switch (by) {
            case 1: {
                string = "image/gif";
                break;
            }
            case 2: {
                string = "image/jpeg";
                break;
            }
            case 3: {
                string = "image/png";
                break;
            }
            case 4: {
                string = "image/tiff";
            }
        }
        return string;
    }
}

