/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    boolean discardEnclosingInstance;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int n) {
        this.accessMode = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int n = 0;
                int n2 = this.arguments.length;
                while (n < n2) {
                    flowInfo = this.arguments[n].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                    ++n;
                }
            }
            TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                flowContext.checkExceptionHandlers(typeBindingArray, this.accessMode == 1 ? (ASTNode)((Object)blockScope.methodScope().referenceContext) : this, flowInfo, blockScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            int n = codeStream.position;
            codeStream.aload_0();
            ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
            if (referenceBinding.erasure().id == 41 || referenceBinding.isEnum()) {
                codeStream.aload_1();
                codeStream.iload_2();
            }
            if (referenceBinding.isNestedType()) {
                codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.discardEnclosingInstance ? null : this.qualification, this);
            }
            this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
            if (referenceBinding.isNestedType()) {
                codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
            }
            if (this.syntheticAccessor != null) {
                int n2 = 0;
                int n3 = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
                while (n2 < n3) {
                    codeStream.aconst_null();
                    ++n2;
                }
                codeStream.invokespecial(this.syntheticAccessor);
            } else {
                codeStream.invokespecial(this.codegenBinding);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if ((flowInfo.tagBits & 1) == 0 && referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.qualification != null);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.codegenBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                }
            }
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        int n2;
        ExplicitConstructorCall.printIndent(n, stringBuffer);
        if (this.qualification != null) {
            this.qualification.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.typeArguments[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.accessMode == 3) {
            stringBuffer.append("this(");
        } else {
            stringBuffer.append("super(");
        }
        if (this.arguments != null) {
            n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer.append(");");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void resolve(BlockScope var1_1) {
        var2_2 = var1_1.methodScope();
        try {
            block28: {
                var3_3 = var2_2.referenceMethod();
                if (var3_3 == null || !var3_3.isConstructor() || ((ConstructorDeclaration)var3_3).constructorCall != this) {
                    var1_1.problemReporter().invalidExplicitConstructorCall(this);
lbl6:
                    // 4 sources

                    return;
                }
                var2_2.isConstructorCall = true;
                var4_4 = var1_1.enclosingReceiverType();
                if (this.accessMode != 3) {
                    var4_4 = var4_4.superclass();
                }
                if (var4_4 == null) ** GOTO lbl6
                if (this.accessMode == 2 && var4_4.erasure().id == 41) {
                    var1_1.problemReporter().cannotInvokeSuperConstructorInEnum(this, var2_2.referenceMethod().binding);
                }
                if (this.qualification != null) {
                    if (this.accessMode != 2) {
                        var1_1.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, var4_4);
                    }
                    if ((var5_5 = var4_4.enclosingType()) == null) {
                        var1_1.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, var4_4);
                        this.discardEnclosingInstance = true;
                    } else {
                        var6_7 = this.qualification.resolveTypeExpecting(var1_1, (TypeBinding)var5_5);
                        this.qualification.computeConversion(var1_1, var6_7, var6_7);
                    }
                }
                if (this.typeArguments == null) break block28;
                var5_6 = this.typeArguments.length;
                var6_8 = false;
                this.genericTypeArguments = new TypeBinding[var5_6];
                var7_10 = 0;
                while (var7_10 < var5_6) {
                    this.genericTypeArguments[var7_10] = this.typeArguments[var7_10].resolveType(var1_1, true);
                    if (this.genericTypeArguments[var7_10] == null) {
                        var6_8 = true;
                    }
                    ++var7_10;
                }
                if (var6_8) ** GOTO lbl6
            }
            var5_5 = Binding.NO_PARAMETERS;
            var6_9 = false;
            if (this.arguments != null) {
                var7_10 = 0;
                var8_11 = this.arguments.length;
                var5_5 = new TypeBinding[var8_11];
                var9_12 = 0;
                while (var9_12 < var8_11) {
                    var10_14 = this.arguments[var9_12];
                    if (var10_14 instanceof CastExpression) {
                        var10_14.bits |= 32;
                        var6_9 = true;
                    }
                    if ((var5_5[var9_12] = var10_14.resolveType(var1_1)) == null) {
                        var7_10 = 1;
                    }
                    ++var9_12;
                }
                if (var7_10 != 0) {
                    var9_13 = new TypeBinding[var8_11];
                    var10_15 = var8_11;
                    while (--var10_15 >= 0) {
                        v0 /* !! */  = var9_13[var10_15] = var5_5[var10_15] == null ? var4_4 : var5_5[var10_15];
                    }
                    this.binding = var1_1.findMethod(var4_4, TypeConstants.INIT, var9_13, this);
                    ** continue;
                }
            } else if (var4_4.erasure().id == 41) {
                var5_5 = new TypeBinding[]{var1_1.getJavaLangString(), TypeBinding.INT};
            }
            if ((this.binding = var1_1.getConstructor(var4_4, var5_5, this)).isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, var1_1, this.accessMode != 1)) {
                    var1_1.problemReporter().deprecatedMethod(this.binding, this);
                }
                ExplicitConstructorCall.checkInvocationArguments(var1_1, null, var4_4, this.binding, this.arguments, var5_5, var6_9, this);
                if (this.binding.isPrivate() || var4_4.isLocalType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = var4_4;
                }
                var1_1.problemReporter().invalidConstructor(this, this.binding);
            }
        }
        finally {
            var2_2.isConstructorCall = false;
        }
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.qualification != null) {
                this.qualification.traverse(aSTVisitor, blockScope);
            }
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

