/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVirtualPrintPage
implements JRPrintPage,
JRVirtualizable,
Serializable {
    protected static final Log log = LogFactory.getLog(JRVirtualPrintPage.class);
    private static final long serialVersionUID = 10200L;
    private static final Random random = new Random(System.currentTimeMillis());
    private static short counter = 1;
    protected List elements = new ArrayList();
    private String uid;
    private transient JRVirtualizer virtualizer;
    private transient IdentityDataProvider[] identityProviders;
    protected JRVirtualizationContext virtualizationContext;

    public JRVirtualPrintPage(JasperPrint jasperPrint, JRVirtualizer jRVirtualizer, JRVirtualizationContext jRVirtualizationContext) {
        this.virtualizationContext = jRVirtualizationContext;
        this.uid = JRVirtualPrintPage.makeUID(jasperPrint);
        this.virtualizer = jRVirtualizer;
        this.identityProviders = null;
        if (jRVirtualizer != null) {
            jRVirtualizer.registerObject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUID(JasperPrint jasperPrint) {
        Random random = JRVirtualPrintPage.random;
        synchronized (random) {
            short s = counter;
            counter = (short)(s + 1);
            return String.valueOf(Integer.toString(System.identityHashCode(jasperPrint))) + "_" + jasperPrint.getPages().size() + "_" + Integer.toString(s) + "_" + Integer.toString(JRVirtualPrintPage.random.nextInt());
        }
    }

    public final String getUID() {
        return this.uid;
    }

    public void setVirtualData(Object object) {
        this.elements = (List)object;
    }

    public Object getVirtualData() {
        return this.elements;
    }

    public void removeVirtualData() {
        this.elements = null;
    }

    public void setIdentityData(Object object) {
        if (this.identityProviders != null) {
            int n = 0;
            while (n < this.identityProviders.length) {
                this.identityProviders[n].setIdentityData(this, (ObjectIDPair[])object);
                ++n;
            }
        }
    }

    public Object getIdentityData() {
        ObjectIDPair[] objectIDPairArray;
        if (this.identityProviders != null) {
            if (this.identityProviders.length == 1) {
                objectIDPairArray = this.identityProviders[0].getIdentityData(this);
            } else if (this.identityProviders.length > 1) {
                HashSet<ObjectIDPair> hashSet = new HashSet<ObjectIDPair>();
                int n = 0;
                while (n < this.identityProviders.length) {
                    ObjectIDPair[] objectIDPairArray2 = this.identityProviders[n].getIdentityData(this);
                    if (objectIDPairArray2 != null) {
                        int n2 = 0;
                        while (n2 < objectIDPairArray2.length) {
                            hashSet.add(objectIDPairArray2[n2]);
                            ++n2;
                        }
                    }
                    ++n;
                }
                objectIDPairArray = hashSet.toArray(new ObjectIDPair[hashSet.size()]);
            } else {
                objectIDPairArray = null;
            }
        } else {
            objectIDPairArray = null;
        }
        return objectIDPairArray;
    }

    public boolean isVirtualized() {
        return this.elements == null;
    }

    public void setVirtualizer(JRVirtualizer jRVirtualizer) {
        this.virtualizer = jRVirtualizer;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void addIdentityDataProvider(IdentityDataProvider identityDataProvider) {
        if (this.identityProviders == null) {
            this.identityProviders = new IdentityDataProvider[]{identityDataProvider};
        } else {
            IdentityDataProvider[] identityDataProviderArray = new IdentityDataProvider[this.identityProviders.length + 1];
            System.arraycopy(this.identityProviders, 0, identityDataProviderArray, 0, this.identityProviders.length);
            identityDataProviderArray[this.identityProviders.length] = identityDataProvider;
            this.identityProviders = identityDataProviderArray;
        }
    }

    public void removeIdentityDataProvider(IdentityDataProvider identityDataProvider) {
        if (this.identityProviders != null) {
            int n = 0;
            while (n < this.identityProviders.length) {
                if (this.identityProviders[n] == identityDataProvider) {
                    IdentityDataProvider[] identityDataProviderArray = new IdentityDataProvider[this.identityProviders.length - 1];
                    System.arraycopy(this.identityProviders, 0, identityDataProviderArray, 0, n);
                    int n2 = this.identityProviders.length - n - 1;
                    if (n2 > 0) {
                        System.arraycopy(this.identityProviders, n + 1, identityDataProviderArray, n, n2);
                    }
                    this.identityProviders = identityDataProviderArray;
                    break;
                }
                ++n;
            }
        }
    }

    public List getElements() {
        this.ensureVirtualData();
        return this.elements;
    }

    protected void ensureVirtualData() {
        if (this.virtualizer != null) {
            this.virtualizer.requestData(this);
        }
    }

    public void setElements(List list) {
        this.cleanVirtualData();
        this.elements = list;
        this.cacheInContext(this.elements);
    }

    protected void cleanVirtualData() {
        if (this.virtualizer != null) {
            this.virtualizer.clearData(this);
        }
    }

    public void addElement(JRPrintElement jRPrintElement) {
        this.ensureVirtualData();
        this.elements.add(jRPrintElement);
        this.cacheInContext(jRPrintElement);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uid = (String)objectInputStream.readObject();
        this.virtualizationContext = (JRVirtualizationContext)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
        this.elements = (List)objectInputStream2.readObject();
        this.afterInternalization();
        this.setThreadVirtualizer();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.ensureVirtualData();
        this.beforeExternalization();
        try {
            objectOutputStream.writeObject(this.uid);
            objectOutputStream.writeObject(this.virtualizationContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream2.writeObject(this.elements);
            objectOutputStream2.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
        finally {
            this.afterExternalization();
        }
    }

    private void setThreadVirtualizer() {
        JRVirtualizer jRVirtualizer = JRVirtualizationHelper.getThreadVirtualizer();
        if (jRVirtualizer != null) {
            this.virtualizer = jRVirtualizer;
            this.virtualizer.registerObject(this);
        }
    }

    protected void finalize() {
        if (this.virtualizer != null) {
            this.virtualizer.deregisterObject(this);
        }
    }

    protected List getDeepElements() {
        ArrayList arrayList = new ArrayList(this.elements.size());
        this.collectDeepElements(this.elements, arrayList);
        return arrayList;
    }

    protected void collectDeepElements(List list, List list2) {
        for (JRPrintElement jRPrintElement : list) {
            list2.add(jRPrintElement);
            if (!(jRPrintElement instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
            this.collectDeepElements(jRPrintFrame.getElements(), list2);
        }
    }

    public void beforeExternalization() {
        this.setElementsExternalData();
    }

    protected void setElementsExternalData() {
        this.traverseDeepElements(new ExternalizationElementVisitor());
    }

    protected void setExternalizationRenderer(JRPrintImage jRPrintImage) {
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null && this.virtualizationContext.hasCachedRenderer(jRRenderable.getId())) {
            jRPrintImage.setRenderer(new JRIdHolderRenderer(jRRenderable));
        }
    }

    protected void cacheInContext(List list) {
        if (list != null && !list.isEmpty()) {
            for (JRPrintElement jRPrintElement : list) {
                this.cacheInContext(jRPrintElement);
            }
        }
    }

    protected void cacheInContext(JRPrintElement jRPrintElement) {
        JRPrintElement jRPrintElement2;
        JRTemplateElement jRTemplateElement;
        if (jRPrintElement instanceof JRTemplatePrintElement && (jRTemplateElement = ((JRTemplatePrintElement)(jRPrintElement2 = (JRTemplatePrintElement)jRPrintElement)).getTemplate()) != null) {
            this.virtualizationContext.cacheTemplate(jRTemplateElement);
        }
        if (jRPrintElement instanceof JRPrintFrame) {
            jRPrintElement2 = (JRPrintFrame)jRPrintElement;
            this.cacheInContext(jRPrintElement2.getElements());
        }
    }

    public void afterInternalization() {
        this.restoreElementsData();
    }

    protected void restoreElementsData() {
        this.traverseDeepElements(new InternalizationElementVisitor());
    }

    public JRVirtualizationContext getContext() {
        return this.virtualizationContext;
    }

    public void afterExternalization() {
        this.restoreElementsData();
    }

    protected void traverseDeepElements(ElementVisitor elementVisitor) {
        this.traverseDeepElements(elementVisitor, this.elements);
    }

    protected void traverseDeepElements(ElementVisitor elementVisitor, List list) {
        for (JRPrintElement jRPrintElement : list) {
            elementVisitor.visitElement(jRPrintElement);
            if (!(jRPrintElement instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
            this.traverseDeepElements(elementVisitor, jRPrintFrame.getElements());
        }
    }

    public static class ObjectIDPair
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final Object o;
        private final int id;

        public ObjectIDPair(Object object) {
            this.o = object;
            this.id = System.identityHashCode(object);
        }

        public Object getObject() {
            return this.o;
        }

        public int getIdentity() {
            return this.id;
        }
    }

    public static interface IdentityDataProvider {
        public ObjectIDPair[] getIdentityData(JRVirtualPrintPage var1);

        public void setIdentityData(JRVirtualPrintPage var1, ObjectIDPair[] var2);
    }

    protected static class JRIdHolderRenderer
    implements JRRenderable,
    Serializable {
        private static final long serialVersionUID = 10200L;
        protected final String id;

        protected JRIdHolderRenderer(JRRenderable jRRenderable) {
            this.id = jRRenderable.getId();
        }

        public String getId() {
            return this.id;
        }

        public byte getType() {
            return 0;
        }

        public byte getImageType() {
            return 0;
        }

        public Dimension2D getDimension() throws JRException {
            return null;
        }

        public byte[] getImageData() throws JRException {
            return null;
        }

        public void render(Graphics2D graphics2D, Rectangle2D rectangle2D) throws JRException {
        }
    }

    protected static class JRIdHolderTemplateElement
    extends JRTemplateElement {
        private static final long serialVersionUID = 10200L;

        protected JRIdHolderTemplateElement(String string) {
            super(string);
        }
    }

    protected static interface ElementVisitor {
        public void visitElement(JRPrintElement var1);
    }

    protected class ExternalizationElementVisitor
    implements ElementVisitor {
        private final Map idTemplates = new HashMap();

        protected ExternalizationElementVisitor() {
        }

        public void visitElement(JRPrintElement jRPrintElement) {
            if (jRPrintElement instanceof JRTemplatePrintElement) {
                this.setExternalizationTemplate((JRTemplatePrintElement)jRPrintElement);
            }
            if (jRPrintElement instanceof JRPrintImage) {
                JRVirtualPrintPage.this.setExternalizationRenderer((JRPrintImage)jRPrintElement);
            }
        }

        protected void setExternalizationTemplate(JRTemplatePrintElement jRTemplatePrintElement) {
            JRTemplateElement jRTemplateElement = jRTemplatePrintElement.getTemplate();
            if (jRTemplateElement != null) {
                if (JRVirtualPrintPage.this.virtualizationContext.hasCachedTemplate(jRTemplateElement.getId())) {
                    String string = jRTemplateElement.getId();
                    JRIdHolderTemplateElement jRIdHolderTemplateElement = (JRIdHolderTemplateElement)this.idTemplates.get(string);
                    if (jRIdHolderTemplateElement == null) {
                        jRIdHolderTemplateElement = new JRIdHolderTemplateElement(string);
                        this.idTemplates.put(string, jRIdHolderTemplateElement);
                    }
                    jRTemplatePrintElement.setTemplate(jRIdHolderTemplateElement);
                } else if (log.isDebugEnabled()) {
                    log.debug("Template " + jRTemplateElement + " having id " + jRTemplateElement.getId() + " not found in virtualization context cache");
                }
            }
        }
    }

    protected class InternalizationElementVisitor
    implements ElementVisitor {
        protected InternalizationElementVisitor() {
        }

        public void visitElement(JRPrintElement jRPrintElement) {
            if (jRPrintElement instanceof JRTemplatePrintElement) {
                this.restoreTemplate((JRTemplatePrintElement)jRPrintElement);
            }
            if (jRPrintElement instanceof JRPrintImage) {
                this.restoreRenderer((JRPrintImage)jRPrintElement);
            }
        }

        protected void restoreTemplate(JRTemplatePrintElement jRTemplatePrintElement) {
            JRTemplateElement jRTemplateElement = jRTemplatePrintElement.getTemplate();
            if (jRTemplateElement != null && jRTemplateElement instanceof JRIdHolderTemplateElement) {
                JRTemplateElement jRTemplateElement2 = JRVirtualPrintPage.this.virtualizationContext.getCachedTemplate(jRTemplateElement.getId());
                if (jRTemplateElement2 == null) {
                    throw new JRRuntimeException("Template " + jRTemplateElement.getId() + " not found in virtualization context.");
                }
                jRTemplatePrintElement.setTemplate(jRTemplateElement2);
            }
        }

        protected void restoreRenderer(JRPrintImage jRPrintImage) {
            JRRenderable jRRenderable = jRPrintImage.getRenderer();
            if (jRRenderable != null && jRRenderable instanceof JRIdHolderRenderer) {
                JRRenderable jRRenderable2 = JRVirtualPrintPage.this.virtualizationContext.getCachedRenderer(jRRenderable.getId());
                if (jRRenderable2 == null) {
                    throw new JRRuntimeException("Renderer " + jRRenderable.getId() + " not found in virtualization context.");
                }
                jRPrintImage.setRenderer(jRRenderable2);
            }
        }
    }
}

