/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

final class PlasticXPBorders {
    private static Border comboBoxArrowButtonBorder;
    private static Border comboBoxEditorBorder;
    private static Border scrollPaneBorder;
    private static Border textFieldBorder;
    private static Border spinnerBorder;
    private static Border rolloverButtonBorder;

    private PlasticXPBorders() {
    }

    static Border getButtonBorder(Insets insets) {
        return new BorderUIResource.CompoundBorderUIResource(new XPButtonBorder(insets), new BasicBorders.MarginBorder());
    }

    static Border getComboBoxArrowButtonBorder() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new XPComboBoxArrowButtonBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new XPComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new XPScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new XPTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getToggleButtonBorder(Insets insets) {
        return new BorderUIResource.CompoundBorderUIResource(new XPButtonBorder(insets), new BasicBorders.MarginBorder());
    }

    static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new XPSpinnerBorder();
        }
        return spinnerBorder;
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new CompoundBorder(new RolloverButtonBorder(), new PlasticBorders.RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    private static class XPButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected final Insets insets;

        protected XPButtonBorder(Insets insets) {
            this.insets = insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticXPUtils.drawDisabledButtonBorder(graphics, n, n2, n3, n4);
                return;
            }
            boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl3 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
            boolean bl4 = bl = abstractButton.isFocusPainted() && abstractButton.hasFocus();
            if (bl2) {
                PlasticXPUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl) {
                PlasticXPUtils.drawFocusedButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl3) {
                PlasticXPUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.insets.top;
            insets.left = this.insets.left;
            insets.bottom = this.insets.bottom;
            insets.right = this.insets.right;
            return insets;
        }
    }

    private static final class XPComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPComboBoxArrowButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)component;
            JComboBox jComboBox = plasticComboBoxButton.getComboBox();
            ButtonModel buttonModel = plasticComboBoxButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticXPUtils.drawDisabledButtonBorder(graphics, n, n2, n3, n4);
            } else {
                boolean bl = buttonModel.isPressed() && buttonModel.isArmed();
                boolean bl2 = jComboBox.hasFocus();
                if (bl) {
                    PlasticXPUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
                } else if (bl2) {
                    PlasticXPUtils.drawFocusedButtonBorder(graphics, n, n2, n3, n4);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
                }
            }
            if (jComboBox.isEditable()) {
                graphics.setColor(buttonModel.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n, n2, 1, 1);
                graphics.fillRect(n, n2 + n4 - 1, 1, 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class XPComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 0);

        private XPComboBoxEditorBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticXPUtils.drawRect(graphics, n, n2, n3 + 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class XPTextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPTextFieldBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = component instanceof JTextComponent && component.isEnabled() && ((JTextComponent)component).isEditable() || component.isEnabled();
            graphics.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticXPUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = XPTextFieldBorder.INSETS.top;
            insets.left = XPTextFieldBorder.INSETS.left;
            insets.bottom = XPTextFieldBorder.INSETS.bottom;
            insets.right = XPTextFieldBorder.INSETS.right;
            return insets;
        }
    }

    private static final class XPScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPScrollPaneBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticXPUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = XPScrollPaneBorder.INSETS.top;
            insets.left = XPScrollPaneBorder.INSETS.left;
            insets.bottom = XPScrollPaneBorder.INSETS.bottom;
            insets.right = XPScrollPaneBorder.INSETS.right;
            return insets;
        }
    }

    private static final class XPSpinnerBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPSpinnerBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            int n5 = UIManager.getInt("ScrollBar.width") - 1;
            graphics.fillRect(n, n2, n3 -= n5, 1);
            graphics.fillRect(n, n2 + 1, 1, n4 - 1);
            graphics.fillRect(n + 1, n2 + n4 - 1, n3 - 1, 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = XPSpinnerBorder.INSETS.top;
            insets.left = XPSpinnerBorder.INSETS.left;
            insets.bottom = XPSpinnerBorder.INSETS.bottom;
            insets.right = XPSpinnerBorder.INSETS.right;
            return insets;
        }
    }

    private static final class RolloverButtonBorder
    extends XPButtonBorder {
        private RolloverButtonBorder() {
            super(new Insets(3, 3, 3, 3));
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!(component instanceof JToggleButton)) {
                if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                }
                return;
            }
            if (buttonModel.isRollover()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    PlasticXPUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
                }
            } else if (buttonModel.isSelected()) {
                PlasticXPUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
            }
        }
    }
}

